/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.ui.customizer;

import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFilesUIs {
    private ConfigFilesUIs() {
    }

    public static String getGroupName(ConfigFileGroup configFileGroup) {
        String string = configFileGroup.getName();
        if (string == null || string.length() == 0) {
            string = NbBundle.getMessage(ConfigFilesUIs.class, (String)"LBL_Unnamed");
        }
        return string;
    }

    public static void setupGroupsList(JList jList) {
        jList.setCellRenderer(new ConfigFileGroupRenderer());
    }

    public static void setupFilesList(JList jList, FileDisplayName fileDisplayName) {
        jList.setCellRenderer(new ConfigFileRenderer(fileDisplayName));
    }

    public static void connectGroupsList(List<ConfigFileGroup> list, JList jList) {
        jList.setModel(new ConfigFileGroupListModel(list));
    }

    public static void connectFilesList(List<File> list, JList jList) {
        jList.setModel(new ConfigFileListModel(list));
    }

    public static void disconnect(JList jList) {
        jList.setModel(new DefaultListModel());
    }

    public static void setupFilesSelectionTable(JTable jTable, FileDisplayName fileDisplayName) {
        jTable.setDefaultRenderer(File.class, new ConfigFileSelectionFileRenderer(fileDisplayName));
        jTable.setDefaultRenderer(Boolean.class, new ConfigFileSelectionBooleanRenderer(jTable.getDefaultRenderer(Boolean.class)));
    }

    public static void connectFilesSelectionTable(List<File> list, Set<File> set, JTable jTable) {
        jTable.setModel(new ConfigFileSelectionTableModel(list, set));
    }

    public static List<File> getSelectedFiles(JTable jTable) {
        return ((ConfigFileSelectionTableModel)jTable.getModel()).getSelectedFiles();
    }

    public static interface FileDisplayName {
        public String getDisplayName(File var1);
    }

    private static final class ConfigFileSelectionBooleanRenderer
    implements TableCellRenderer {
        private final TableCellRenderer delegate;

        public ConfigFileSelectionBooleanRenderer(TableCellRenderer tableCellRenderer) {
            this.delegate = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            if (!(jTable.getModel() instanceof ConfigFileSelectionTableModel)) {
                return component;
            }
            ConfigFileSelectionTableModel configFileSelectionTableModel = (ConfigFileSelectionTableModel)jTable.getModel();
            component.setEnabled(configFileSelectionTableModel.isEnabled(n));
            String string = null;
            if (!configFileSelectionTableModel.isEnabled(n)) {
                string = NbBundle.getMessage(ConfigFilesUIs.class, (String)"LBL_FileAlreadyAdded");
            }
            if (component instanceof JComponent) {
                ((JComponent)component).setToolTipText(string);
            }
            return component;
        }
    }

    private static final class ConfigFileSelectionFileRenderer
    extends DefaultTableCellRenderer {
        private final FileDisplayName displayName;

        public ConfigFileSelectionFileRenderer(FileDisplayName fileDisplayName) {
            this.displayName = fileDisplayName;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            File file = (File)object;
            jLabel.setText(this.displayName.getDisplayName(file));
            if (!(jTable.getModel() instanceof ConfigFileSelectionTableModel)) {
                return jLabel;
            }
            ConfigFileSelectionTableModel configFileSelectionTableModel = (ConfigFileSelectionTableModel)jTable.getModel();
            String string = null;
            if (!configFileSelectionTableModel.isEnabled(n)) {
                string = NbBundle.getMessage(ConfigFilesUIs.class, (String)"LBL_FileAlreadyAdded");
            }
            jLabel.setToolTipText(string);
            jLabel.setEnabled(configFileSelectionTableModel.isEnabled(n));
            return jLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConfigFileSelectionTableModel
    implements TableModel {
        private final List<File> availableFiles;
        private final Set<File> alreadySelectedFiles;
        private boolean[] selected;

        public ConfigFileSelectionTableModel(List<File> list, Set<File> set) {
            this.availableFiles = list;
            this.alreadySelectedFiles = set;
            this.selected = new boolean[list.size()];
        }

        @Override
        public void addTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? Boolean.class : File.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? "" : "File Name";
        }

        @Override
        public int getRowCount() {
            return this.availableFiles.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? Boolean.valueOf(this.selected[n]) : (Serializable)this.availableFiles.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void removeTableModelListener(TableModelListener tableModelListener) {
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (this.isEnabled(n)) {
                this.selected[n] = (Boolean)object;
            }
        }

        public boolean isEnabled(int n) {
            return !this.alreadySelectedFiles.contains(this.availableFiles.get(n));
        }

        public List<File> getSelectedFiles() {
            ArrayList<File> arrayList = new ArrayList<File>(this.availableFiles.size());
            for (int i = 0; i < this.availableFiles.size(); ++i) {
                if (!this.selected[i]) continue;
                arrayList.add(this.availableFiles.get(i));
            }
            return arrayList;
        }
    }

    private static final class ConfigFileRenderer
    extends DefaultListCellRenderer {
        private final FileDisplayName displayName;

        public ConfigFileRenderer(FileDisplayName fileDisplayName) {
            this.displayName = fileDisplayName;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            File file = (File)object;
            jLabel.setText(this.displayName.getDisplayName(file));
            return jLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConfigFileListModel
    implements ListModel {
        private List<File> files;

        public ConfigFileListModel(List<File> list) {
            this.files = list;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        public Object getElementAt(int n) {
            return this.files.get(n);
        }

        @Override
        public int getSize() {
            return this.files.size();
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private static final class ConfigFileGroupRenderer
    extends DefaultListCellRenderer {
        private ConfigFileGroupRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            ConfigFileGroup configFileGroup = (ConfigFileGroup)object;
            jLabel.setText(ConfigFilesUIs.getGroupName(configFileGroup));
            return jLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConfigFileGroupListModel
    implements ListModel {
        private final List<ConfigFileGroup> groups;

        public ConfigFileGroupListModel(List<ConfigFileGroup> list) {
            this.groups = list;
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
        }

        public ConfigFileGroup getElementAt(int n) {
            return this.groups.get(n);
        }

        @Override
        public int getSize() {
            return this.groups.size();
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }
}

