/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.spring.beans.refactoring.Modifications;
import org.openide.util.Exceptions;

public class ModificationTransaction
implements Transaction {
    private final Modifications mods;
    private final List<BackupFacility.Handle> handles = new ArrayList<BackupFacility.Handle>();
    private boolean committed;

    public ModificationTransaction(Modifications modifications) {
        this.mods = modifications;
    }

    public void commit() {
        if (this.committed) {
            this.restore();
        } else {
            try {
                this.handles.add(BackupFacility.getDefault().backup(this.mods.getModifiedFileObjects()));
                this.mods.commit();
                this.committed = true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    public void rollback() {
        this.restore();
    }

    private void restore() {
        for (BackupFacility.Handle handle : this.handles) {
            try {
                handle.restore();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

