/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import org.netbeans.editor.TokenItem;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;

public final class ContextUtilities {
    public static final String P_NAMESPACE = "http://www.springframework.org/schema/p";

    private ContextUtilities() {
    }

    public static boolean isPNamespaceName(DocumentContext documentContext, String string) {
        String string2;
        String string3 = ContextUtilities.getPrefixFromNodeName(string);
        return string3 != null && P_NAMESPACE.equals(string2 = documentContext.lookupNamespacePrefix(string3));
    }

    public static boolean isValueToken(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID().getNumericID() == 7;
    }

    public static boolean isTagToken(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID().getNumericID() == 4;
    }

    public static boolean isAttributeToken(TokenItem tokenItem) {
        return tokenItem != null && tokenItem.getTokenID().getNumericID() == 5;
    }

    public static TokenItem getAttributeToken(TokenItem tokenItem) {
        if (ContextUtilities.isValueToken(tokenItem)) {
            TokenItem tokenItem2 = tokenItem.getPrevious();
            while (tokenItem2.getTokenID().getNumericID() != 6) {
                tokenItem2 = tokenItem2.getPrevious();
            }
            TokenItem tokenItem3 = tokenItem2.getPrevious();
            while (tokenItem3.getTokenID().getNumericID() != 5) {
                tokenItem3 = tokenItem3.getPrevious();
            }
            return tokenItem3;
        }
        return null;
    }

    public static Tag getCurrentTagElement(DocumentContext documentContext) {
        SyntaxElement syntaxElement = documentContext.getCurrentElement();
        if (syntaxElement instanceof StartTag) {
            return (StartTag)syntaxElement;
        }
        if (syntaxElement instanceof EmptyTag) {
            return (EmptyTag)syntaxElement;
        }
        return null;
    }

    public static TokenItem getAttributeToken(DocumentContext documentContext) {
        if (ContextUtilities.isValueToken(documentContext.getCurrentToken())) {
            TokenItem tokenItem = documentContext.getCurrentToken().getPrevious();
            while (tokenItem.getTokenID().getNumericID() != 6) {
                tokenItem = tokenItem.getPrevious();
            }
            TokenItem tokenItem2 = tokenItem.getPrevious();
            while (tokenItem2.getTokenID().getNumericID() != 5) {
                tokenItem2 = tokenItem2.getPrevious();
            }
            return tokenItem2;
        }
        return null;
    }

    public static String getAttributeTokenImage(DocumentContext documentContext) {
        TokenItem tokenItem = ContextUtilities.getAttributeToken(documentContext);
        if (tokenItem != null) {
            return tokenItem.getImage();
        }
        return null;
    }

    public static String getPrefixFromTag(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? null : string.substring(0, string.indexOf(":"));
    }

    public static String getLocalNameFromTag(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? string : string.substring(string.indexOf(":") + 1, string.length());
    }

    public static String getPrefixFromNamespaceDeclaration(String string) {
        if (!string.startsWith("xmlns")) {
            return null;
        }
        int n = "xmlns".length();
        if (string.length() == n) {
            return "";
        }
        if (string.charAt(n) == ':') {
            return string.substring(n + 1);
        }
        return null;
    }

    public static String getPrefixFromNodeName(String string) {
        int n = string.indexOf(58);
        if (n <= 0) {
            return null;
        }
        return string.substring(0, n);
    }

    public static StartTag getRoot(SyntaxElement syntaxElement) {
        StartTag startTag = null;
        while (syntaxElement != null) {
            if (syntaxElement instanceof StartTag) {
                startTag = (StartTag)syntaxElement;
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        return startTag;
    }

    public static boolean isPNamespaceAdded(DocumentContext documentContext) {
        return documentContext.getDeclaredNamespaces().contains(P_NAMESPACE);
    }
}

