/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.SpringCompletionResult;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Completor {
    private volatile List<SpringXMLConfigCompletionItem> cache = new ArrayList<SpringXMLConfigCompletionItem>();
    private volatile int anchorOffset = -1;
    private final int invocationOffset;
    private volatile boolean hasAdditionalItems = false;
    private volatile boolean cancelled = false;

    protected Completor(int n) {
        this.invocationOffset = n;
    }

    public final SpringCompletionResult complete(CompletionContext completionContext) {
        try {
            this.anchorOffset = this.initAnchorOffset(completionContext);
            this.compute(completionContext);
            return SpringCompletionResult.create(this.cache, this.anchorOffset, this.hasAdditionalItems, this.getAdditionalItemsText());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return SpringCompletionResult.NONE;
        }
    }

    protected abstract int initAnchorOffset(CompletionContext var1);

    protected abstract void compute(CompletionContext var1) throws IOException;

    public boolean canFilter(CompletionContext completionContext) {
        return false;
    }

    public final SpringCompletionResult filter(CompletionContext completionContext) {
        return SpringCompletionResult.create(this.doFilter(completionContext), this.anchorOffset, this.hasAdditionalItems, this.getAdditionalItemsText());
    }

    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext completionContext) {
        throw new UnsupportedOperationException("No default implementation");
    }

    protected final void addCacheItem(SpringXMLConfigCompletionItem springXMLConfigCompletionItem) {
        this.cache.add(springXMLConfigCompletionItem);
    }

    protected List<SpringXMLConfigCompletionItem> getCacheItems() {
        return this.cache;
    }

    protected final int getAnchorOffset() {
        return this.anchorOffset;
    }

    protected final boolean isCancelled() {
        return this.cancelled;
    }

    protected final void cancel() {
        this.cancelled = true;
    }

    protected final int getInvocationOffset() {
        return this.invocationOffset;
    }

    protected String getAdditionalItemsText() {
        return "";
    }

    protected void setAdditionalItems(boolean bl) {
        this.hasAdditionalItems = bl;
    }
}

