/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makewizard.TargetData;
import org.openide.text.NbDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTargetPanel
extends MakefileWizardPanel {
    static final long serialVersionUID = -5820333613938630399L;
    private JTextField dependsOn;
    private JEditorPane actionText;
    private StyledDocument actionDoc;
    private String depends;
    private boolean initialized;
    private boolean inAddNotify = false;
    private int key;

    CustomTargetPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_CustomTargetPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.getString("LBL_DependsOn"));
        jLabel.setDisplayedMnemonic(this.getString("MNEM_DependsOn").charAt(0));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.dependsOn = new JTextField();
        jLabel.setLabelFor(this.dependsOn);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.dependsOn, gridBagConstraints);
        jLabel = new JLabel(this.getString("LBL_ActionDisplay"));
        jLabel.setDisplayedMnemonic(this.getString("MNEM_ActionDisplay").charAt(0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.add((Component)jPanel, "North");
        this.actionText = new JEditorPane("text/x-make", "");
        jLabel.setLabelFor(this.actionText);
        if (!(this.actionText.getDocument() instanceof StyledDocument)) {
            this.actionText.setDocument(new DefaultStyledDocument());
        }
        this.actionDoc = (StyledDocument)this.actionText.getDocument();
        JScrollPane jScrollPane = new JScrollPane(this.actionText);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        this.add((Component)jScrollPane, "Center");
        this.dependsOn.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                CustomTargetPanel.this.insertActionDisplay(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                CustomTargetPanel.this.removeActionDisplay(documentEvent);
            }
        });
    }

    private void insertActionDisplay(DocumentEvent documentEvent) {
        if (!this.inAddNotify) {
            Element element;
            String string;
            TargetData targetData;
            block3: {
                targetData = this.getMakefileData().getCurrentTarget();
                int n = documentEvent.getOffset();
                string = this.dependsOn.getText();
                String string2 = string.substring(n, n + documentEvent.getLength());
                n += targetData.getName().length() + 2;
                element = this.actionDoc.getParagraphElement(0);
                NbDocument.unmarkGuarded((StyledDocument)this.actionDoc, (int)element.getStartOffset(), (int)(element.getEndOffset() - element.getStartOffset() + 1));
                try {
                    this.actionDoc.insertString(n, string2, null);
                }
                catch (BadLocationException badLocationException) {
                    if (!IpeUtils.IfdefDiagnostics) break block3;
                    System.out.println("BadLocationException: " + badLocationException.getMessage() + "\n\toffset = " + badLocationException.offsetRequested());
                    badLocationException.printStackTrace();
                }
            }
            this.depends = string;
            NbDocument.markGuarded((StyledDocument)this.actionDoc, (int)element.getStartOffset(), (int)(targetData.getName().length() + this.depends.length() + 3));
        }
    }

    private void removeActionDisplay(DocumentEvent documentEvent) {
        if (!this.inAddNotify) {
            Element element;
            TargetData targetData;
            block3: {
                targetData = this.getMakefileData().getCurrentTarget();
                int n = targetData.getName().length() + 2 + documentEvent.getOffset();
                element = this.actionDoc.getParagraphElement(0);
                NbDocument.unmarkGuarded((StyledDocument)this.actionDoc, (int)element.getStartOffset(), (int)(element.getEndOffset() - element.getStartOffset() + 1));
                try {
                    this.actionDoc.remove(n, documentEvent.getLength());
                }
                catch (BadLocationException badLocationException) {
                    if (!IpeUtils.IfdefDiagnostics) break block3;
                    System.out.println("BadLocationException[6]: " + badLocationException.getMessage() + "\n\toffset = " + badLocationException.offsetRequested());
                    badLocationException.printStackTrace();
                }
            }
            this.depends = this.dependsOn.getText();
            NbDocument.markGuarded((StyledDocument)this.actionDoc, (int)element.getStartOffset(), (int)(targetData.getName().length() + this.depends.length() + 3));
        }
    }

    @Override
    public void validateData(ArrayList<String> arrayList, int n) {
        String string;
        int n2;
        int n3;
        block6: {
            AbstractDocument abstractDocument = (AbstractDocument)this.actionText.getDocument();
            n3 = 0;
            n2 = 0;
            try {
                string = abstractDocument.getText(0, abstractDocument.getLength());
            }
            catch (BadLocationException badLocationException) {
                string = "";
                if (!IpeUtils.IfdefDiagnostics) break block6;
                System.out.println("BadLocationException validating target");
                badLocationException.printStackTrace();
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0 || n3 > 0) {
                ++n3;
                continue;
            }
            if (string2.startsWith("\t")) continue;
            ++n2;
        }
        if (n3 > 0) {
            this.warn(arrayList, WARN_EXTRA_LINES_IN_TARGET, String.valueOf(n3));
        }
        if (n2 > 0) {
            this.warn(arrayList, WARN_INVALID_LINES_IN_TARGET, String.valueOf(n2));
        }
    }

    @Override
    public void addNotify() {
        block15: {
            StringBuilder stringBuilder;
            TargetData targetData;
            block14: {
                block13: {
                    targetData = this.getMakefileData().getCurrentTarget();
                    if (!this.initialized) {
                        this.create();
                        this.initialized = true;
                    }
                    this.key = targetData.getKey();
                    this.inAddNotify = true;
                    this.depends = targetData.getDependsOn();
                    if (this.depends == null) {
                        this.depends = "";
                    }
                    this.dependsOn.setText(this.depends);
                    Element element = this.actionDoc.getParagraphElement(0);
                    NbDocument.unmarkGuarded((StyledDocument)this.actionDoc, (int)element.getStartOffset(), (int)(element.getEndOffset() - element.getStartOffset() + 1));
                    try {
                        this.actionDoc.remove(0, this.actionDoc.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        if (!IpeUtils.IfdefDiagnostics) break block13;
                        System.out.println("BadLocationException[1]: " + badLocationException.getMessage() + "\n\toffset = " + badLocationException.offsetRequested());
                        badLocationException.printStackTrace();
                    }
                }
                stringBuilder = new StringBuilder(targetData.getName());
                if (targetData.getName().equals("clean")) {
                    stringBuilder.append(":: ");
                } else {
                    stringBuilder.append(": ");
                }
                if (this.depends.length() > 0) {
                    stringBuilder.append(this.depends);
                }
                stringBuilder.append("\n");
                try {
                    this.actionDoc.insertString(0, stringBuilder.toString(), null);
                }
                catch (BadLocationException badLocationException) {
                    if (!IpeUtils.IfdefDiagnostics) break block14;
                    System.out.println("BadLocationException[2]: " + badLocationException.getMessage() + "\n\toffset = " + badLocationException.offsetRequested());
                    badLocationException.printStackTrace();
                }
            }
            NbDocument.markGuarded((StyledDocument)this.actionDoc, (int)0, (int)stringBuilder.length());
            ArrayList arrayList = targetData.getActions();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i).toString();
                stringBuilder2.append("\t").append(string).append("\n");
            }
            if (stringBuilder2.length() == 0) {
                stringBuilder2.append("\t");
            }
            try {
                this.actionDoc.insertString(stringBuilder.length(), stringBuilder2.toString(), null);
            }
            catch (BadLocationException badLocationException) {
                if (!IpeUtils.IfdefDiagnostics) break block15;
                System.out.println("BadLocationException[3]: " + badLocationException.getMessage() + "\n\toffset = " + badLocationException.offsetRequested());
                badLocationException.printStackTrace();
            }
        }
        super.addNotify();
        this.inAddNotify = false;
    }

    @Override
    public void removeNotify() {
        String string;
        TargetData targetData;
        block4: {
            super.removeNotify();
            targetData = this.getMakefileData().getTarget(this.key);
            string = null;
            targetData.setDependsOn(this.depends);
            try {
                string = this.actionDoc.getText(0, this.actionDoc.getLength());
            }
            catch (BadLocationException badLocationException) {
                if (!IpeUtils.IfdefDiagnostics) break block4;
                System.out.println("BadLocationException[4]: " + badLocationException.getMessage() + "\n\toffset = " + badLocationException.offsetRequested());
                badLocationException.printStackTrace();
            }
        }
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
            stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
            targetData.setActions(arrayList);
        }
    }
}

