/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makewizard;

import java.io.File;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makewizard.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makewizard.MakefileWizard;
import org.netbeans.modules.cnd.makewizard.TargetData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOutputPanel
extends DirectoryChooserPanel {
    static final long serialVersionUID = 2730227827286861351L;
    private int key;
    private boolean initialized;

    public BuildOutputPanel(MakefileWizard makefileWizard) {
        super(makefileWizard);
        String string = this.getString("LBL_BuildOutputPanel");
        this.setSubTitle(string);
        this.getAccessibleContext().setAccessibleDescription(string);
        this.initialized = false;
    }

    private void create() {
        this.create(this.getString("LBL_TargetDirectory"), 2);
        this.getLabel().setLabelFor(this.getText());
        this.getLabel().setDisplayedMnemonic(this.getString("MNEM_TargetDirectory").charAt(0));
    }

    @Override
    public void validateData(ArrayList<String> arrayList, int n) {
        TargetData targetData = this.getMakefileData().getTarget(n);
        String string = this.getMakefileData().getBaseDirectory(true);
        String string2 = IpeUtils.expandPath(targetData.getOutputDirectory());
        File file = null;
        File file2 = null;
        File file3 = null;
        if (string2.length() > 0 && !string2.equals(string)) {
            file = string2.startsWith(File.separator) ? new File(string2) : new File(string, string2);
            file2 = file.getParentFile();
            file3 = new File(string);
        }
        if (file != null && !file.equals(file3)) {
            if (!file.exists()) {
                if (file2 == null || !file2.canWrite()) {
                    this.warn(arrayList, WARN_CANNOT_CREATE_OUTPUT_DIR, file.getPath());
                }
            } else if (!file.canWrite()) {
                this.warn(arrayList, WARN_CANNOT_WRITE_TO_OUTPUT_DIR, file.getPath());
            }
        }
    }

    @Override
    public void addNotify() {
        String string;
        TargetData targetData = this.getMakefileData().getCurrentTarget();
        String string2 = string = targetData.getOutputDirectory();
        this.key = targetData.getKey();
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        if (string.charAt(0) == '$') {
            string = IpeUtils.expandPath(string2);
        }
        if (string.charAt(0) == '/' || string.charAt(0) == '~') {
            this.getText().setText(string2);
        } else {
            this.getText().setText(IpeUtils.getRelativePath(this.getMakefileData().getBaseDirectory(), string2));
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TargetData targetData = this.getMakefileData().getTarget(this.key);
        String string = this.getText().getText();
        if (string == null) {
            string = ".";
        }
        if ((string = string.trim()).length() > 1) {
            string = IpeUtils.trimpath(string);
        }
        if (string.length() == 0) {
            string = ".";
        }
        targetData.setOutputDirectory(string);
    }
}

