/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.loaders.CoreElfObject;
import org.netbeans.modules.cnd.loaders.DllObject;
import org.netbeans.modules.cnd.loaders.ExeElfObject;
import org.netbeans.modules.cnd.loaders.ExeObject;
import org.netbeans.modules.cnd.loaders.OrphanedElfObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class ExeLoader
extends UniFileLoader {
    static final long serialVersionUID = -602486606840357846L;
    private static String lastMime;
    private static Reference<FileObject> lastFo;
    private static final String KNOWN_EXEFILE_TYPE = "org.netbeans.modules.cnd.ExeLoader.KNOWN_EXEFILE_TYPE";

    public ExeLoader() {
        super("org.netbeans.modules.cnd.loaders.ExeObject");
    }

    public ExeLoader(String string) {
        super(string);
    }

    protected String actionsContext() {
        return "Loaders/application/x-executable+elf/Actions/";
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(ExeLoader.class, (String)"PROP_ExeLoader_Name");
    }

    protected FileObject findPrimaryFile(FileObject fileObject) {
        if (fileObject.isFolder()) {
            return null;
        }
        String string = fileObject.getMIMEType();
        if ("application/x-elf".equals(string)) {
            String string2 = fileObject.getNameExt();
            string = string2.equals("core") ? "application/x-core+elf" : (string2.indexOf(".so.") >= 0 ? "application/x-shobj+elf" : "application/x-executable+elf");
        }
        if ("application/x-exe".equals(string) || "application/x-exe+dll".equals(string) || "application/x-executable+elf".equals(string) || "application/x-core+elf".equals(string) || "application/x-shobj+elf".equals(string) || "application/x-object+elf".equals(string)) {
            lastMime = string;
            lastFo = new WeakReference<FileObject>(fileObject);
            return fileObject;
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        FileObject fileObject2 = lastFo.get();
        String string = fileObject.equals(fileObject2) ? lastMime : fileObject.getMIMEType();
        if (string.equals("application/x-exe")) {
            return new ExeObject(fileObject, this);
        }
        if (string.equals("application/x-executable+elf")) {
            return new ExeElfObject(fileObject, this);
        }
        if (string.equals("application/x-core+elf")) {
            return new CoreElfObject(fileObject, this);
        }
        if (string.equals("application/x-shobj+elf")) {
            return new DllObject(fileObject, this);
        }
        return new OrphanedElfObject(fileObject, this);
    }
}

