/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.compilers.ToolchainProject;
import org.netbeans.modules.cnd.execution.ErrorParserProvider;
import org.netbeans.modules.cnd.execution.impl.ErrorAnnotation;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerLineConvertor
implements LineConvertor {
    private final List<ErrorParserProvider.ErrorParser> parsers = new ArrayList<ErrorParserProvider.ErrorParser>();
    private static final int LENGTH_TRESHOLD = 2048;

    public CompilerLineConvertor(Project project, ExecutionEnvironment executionEnvironment, FileObject fileObject) {
        List<CompilerSet.CompilerFlavor> list = this.getCompilerSet(project, executionEnvironment);
        for (CompilerSet.CompilerFlavor compilerFlavor : list) {
            ErrorParserProvider.ErrorParser errorParser = ErrorParserProvider.getDefault().getErorParser(compilerFlavor, executionEnvironment, fileObject);
            if (errorParser == null) continue;
            this.parsers.add(errorParser);
        }
        ErrorAnnotation.getInstance().detach(null);
    }

    public List<ConvertedLine> convert(String string) {
        try {
            return this.handleLine(string);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    private List<ConvertedLine> handleLine(String string) throws IOException {
        if (string.length() < 2048) {
            for (ErrorParserProvider.ErrorParser errorParser : this.parsers) {
                ErrorParserProvider.Result result = errorParser.handleLine(string);
                if (result == null || !result.result()) continue;
                return result.converted();
            }
        }
        return null;
    }

    private List<CompilerSet.CompilerFlavor> getCompilerSet(Project project, ExecutionEnvironment executionEnvironment) {
        Object object;
        ToolchainProject toolchainProject;
        CompilerSet compilerSet = null;
        if (project != null && (toolchainProject = (ToolchainProject)project.getLookup().lookup(ToolchainProject.class)) != null) {
            compilerSet = toolchainProject.getCompilerSet();
        }
        if (compilerSet == null) {
            compilerSet = CompilerSetManager.getDefault().getDefaultCompilerSet();
        }
        int n = PlatformTypes.getDefaultPlatform();
        try {
            object = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
            switch (object.getOSFamily()) {
                case SUNOS: {
                    if (object.getCpuFamily() == HostInfo.CpuFamily.SPARC) {
                        n = 0;
                        break;
                    }
                    n = 1;
                    break;
                }
                case WINDOWS: {
                    n = 3;
                    break;
                }
                case LINUX: {
                    n = 2;
                    break;
                }
                case MACOSX: {
                    n = 4;
                    break;
                }
                default: {
                    n = 5;
                    break;
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        object = new ArrayList();
        object.add(compilerSet.getCompilerFlavor());
        for (CompilerSet.CompilerFlavor compilerFlavor : CompilerSet.CompilerFlavor.getFlavors(n)) {
            if (object.contains(compilerFlavor)) continue;
            boolean bl = false;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                CompilerSet.CompilerFlavor compilerFlavor2 = (CompilerSet.CompilerFlavor)iterator.next();
                if (!this.isScannerEquals(compilerFlavor2, compilerFlavor)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object.add(compilerFlavor);
        }
        return object;
    }

    private boolean isScannerEquals(CompilerSet.CompilerFlavor compilerFlavor, CompilerSet.CompilerFlavor compilerFlavor2) {
        int n;
        ToolchainManager.ScannerDescriptor scannerDescriptor = compilerFlavor.getToolchainDescriptor().getScanner();
        ToolchainManager.ScannerDescriptor scannerDescriptor2 = compilerFlavor2.getToolchainDescriptor().getScanner();
        if (scannerDescriptor.getPatterns().size() != scannerDescriptor2.getPatterns().size()) {
            return false;
        }
        for (n = 0; n < scannerDescriptor.getPatterns().size(); ++n) {
            if (scannerDescriptor.getPatterns().get(n).getPattern().equals(scannerDescriptor2.getPatterns().get(n).getPattern())) continue;
            return false;
        }
        if (!this.isEquals(scannerDescriptor.getEnterDirectoryPattern(), scannerDescriptor2.getEnterDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scannerDescriptor.getLeaveDirectoryPattern(), scannerDescriptor2.getLeaveDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scannerDescriptor.getChangeDirectoryPattern(), scannerDescriptor2.getChangeDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scannerDescriptor.getMakeAllInDirectoryPattern(), scannerDescriptor2.getMakeAllInDirectoryPattern())) {
            return false;
        }
        if (!this.isEquals(scannerDescriptor.getStackHeaderPattern(), scannerDescriptor2.getStackHeaderPattern())) {
            return false;
        }
        if (!this.isEquals(scannerDescriptor.getStackNextPattern(), scannerDescriptor2.getStackNextPattern())) {
            return false;
        }
        if (scannerDescriptor.getFilterOutPatterns().size() != scannerDescriptor2.getFilterOutPatterns().size()) {
            return false;
        }
        for (n = 0; n < scannerDescriptor.getFilterOutPatterns().size(); ++n) {
            if (scannerDescriptor.getFilterOutPatterns().get(n).equals(scannerDescriptor2.getFilterOutPatterns().get(n))) continue;
            return false;
        }
        return true;
    }

    private boolean isEquals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }
}

