/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser;

import org.openide.ErrorManager;

public class CppFoldRecord {
    public static final int INITIAL_COMMENT_FOLD = 1;
    public static final int BLOCK_COMMENT_FOLD = 2;
    public static final int COMMENTS_FOLD = 3;
    public static final int INCLUDES_FOLD = 4;
    public static final int IFDEF_FOLD = 5;
    public static final int CLASS_FOLD = 6;
    public static final int FUNCTION_FOLD = 7;
    public static final int CONSTRUCTOR_FOLD = 8;
    public static final int DESTRUCTOR_FOLD = 9;
    public static final int NAMESPACE_FOLD = 10;
    private int type;
    private int startLnum;
    private int endLnum;
    private int startOffset;
    private int endOffset;
    private static final ErrorManager log = ErrorManager.getDefault().getInstance("CppFoldTracer");

    public CppFoldRecord(int n, int n2, int n3, int n4, int n5) {
        this.type = n;
        this.startLnum = n2;
        this.startOffset = n3;
        this.endLnum = n4;
        this.endOffset = n5;
        log.log(this.toString() + " [" + Thread.currentThread().getName() + "]");
    }

    public CppFoldRecord(int n, int n2, int n3) {
        this.type = n;
        this.startLnum = -1;
        this.startOffset = n2;
        this.endLnum = -1;
        this.endOffset = n3;
    }

    public void setLines(int n, int n2) {
        this.startLnum = n;
        this.endLnum = n2;
    }

    public int getType() {
        return this.type;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getStartLine() {
        assert (this.startLnum != -1);
        return this.startLnum;
    }

    public int getEndLine() {
        assert (this.endLnum != -1);
        return this.endLnum;
    }

    public String toString() {
        String string = "Unknown Fold";
        switch (this.type) {
            case 1: {
                string = "INITIAL_COMMENT_FOLD";
                break;
            }
            case 2: {
                string = "BLOCK_COMMENT_FOLD";
                break;
            }
            case 3: {
                string = "COMMENTS_FOLD";
                break;
            }
            case 4: {
                string = "INCLUDES_FOLD";
                break;
            }
            case 5: {
                string = "IFDEF_FOLD";
                break;
            }
            case 6: {
                string = "CLASS_FOLD";
                break;
            }
            case 7: {
                string = "FUNCTION_FOLD";
                break;
            }
            case 8: {
                string = "CONSTRUCTOR_FOLD";
                break;
            }
            case 9: {
                string = "DESTRUCTOR_FOLD";
                break;
            }
            case 10: {
                string = "NAMESPACE_FOLD";
                break;
            }
        }
        return string + " (" + this.startLnum + ", " + this.startOffset + ", " + this.endLnum + ", " + this.endOffset + ")";
    }
}

