/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.BrowseFolders;
import org.netbeans.modules.cnd.editor.filecreation.CndPanelGUI;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

class NewCndClassPanelGUI
extends CndPanelGUI
implements ActionListener {
    private String sourceExt;
    private String headerExt;
    private final MIMEExtensions sourceExtensions = MIMEExtensions.get((String)"text/x-c++");
    private final MIMEExtensions headerExtensions = MIMEExtensions.get((String)"text/x-h");
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JComboBox cbHeaderExtension;
    private JComboBox cbSourceExtension;
    private JLabel classNameLbl;
    private JTextField classNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JButton headerBrowseButton;
    private JTextField headerFolderTextField;
    private JTextField headerTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    NewCndClassPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component) {
        super(project, sourceGroupArray);
        this.initComponents();
        this.initMnemonics();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        this.initValues(null, null, null);
        this.browseButton.addActionListener(this);
        this.headerBrowseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.classNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.headerFolderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject fileObject, FileObject fileObject2, String string) {
        Object object;
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        this.folders = sources.getSourceGroups("generic");
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup sourceGroup = NewCndClassPanelGUI.getPreselectedGroup(this.folders, fileObject2);
        this.locationComboBox.setSelectedItem(sourceGroup);
        this.folderTextField.setText(NewCndClassPanelGUI.getRelativeNativeName(sourceGroup.getRootFolder(), fileObject2));
        String string2 = null;
        try {
            if (fileObject != null) {
                object = DataObject.find((FileObject)fileObject);
                string2 = object.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string2 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string2);
        this.sourceExt = this.sourceExtensions.getDefaultExtension();
        this.cbSourceExtension.setSelectedItem(this.sourceExt);
        this.headerExt = this.headerExtensions.getDefaultExtension();
        this.cbHeaderExtension.setSelectedItem(this.headerExt);
        if (fileObject != null) {
            if (string == null) {
                FileObject fileObject3;
                object = NewCndClassPanelGUI.getMessage("NewClassSuggestedName");
                string = object;
                FileObject fileObject4 = fileObject3 = fileObject2 != null ? fileObject2 : this.getTargetGroup().getRootFolder();
                if (fileObject3 != null) {
                    string = string + NewCndClassPanelGUI.generateUniqueSuffix(fileObject3, NewCndClassPanelGUI.getFileName(string), this.sourceExt, this.headerExt);
                }
            }
            this.classNameTextField.setText(string);
            this.classNameTextField.selectAll();
        }
    }

    public SourceGroup getTargetGroup() {
        Object object = this.locationComboBox.getSelectedItem();
        if (object == null && (object = this.locationComboBox.getItemAt(this.locationComboBox.getSelectedIndex())) == null) {
            object = this.locationComboBox.getItemAt(0);
        }
        return (SourceGroup)object;
    }

    public String getTargetFolder() {
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = this.getSourceFileName();
        if (string.length() == 0 || string.charAt(string.length() - 1) == '.') {
            return null;
        }
        return string;
    }

    private String createdFileName(JTextField jTextField) {
        FileObject fileObject = this.getTargetGroup().getRootFolder();
        String string = jTextField.getText().trim();
        String string2 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/");
        return string2.replace('/', File.separatorChar);
    }

    protected void updateCreatedFile() {
        String string = this.createdFileName(this.folderTextField) + this.getSourceFileName();
        String string2 = this.createdFileName(this.headerFolderTextField) + this.getHeaderFileName();
        if (!string.equals(this.fileTextField.getText()) || !string2.equals(this.headerTextField.getText())) {
            this.fileTextField.setText(string);
            this.headerTextField.setText(string2);
            this.changeSupport.fireChange();
        }
    }

    public String getSourceFileName() {
        return NewCndClassPanelGUI.getFileName(this.getClassName()) + "." + this.sourceExt;
    }

    private DefaultComboBoxModel getSourceExtensionsModel() {
        return new DefaultComboBoxModel(new Vector(this.sourceExtensions.getValues()));
    }

    public String getHeaderFileName() {
        return NewCndClassPanelGUI.getFileName(this.getClassName()) + "." + this.headerExt;
    }

    public String getHeaderFolder() {
        String string = this.headerFolderTextField.getText().trim();
        if (string.length() == 0) {
            return "";
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getHeaderName() {
        String string = this.getHeaderFileName();
        if (string.length() == 0 || string.charAt(string.length() - 1) == '.') {
            return null;
        }
        return string;
    }

    private DefaultComboBoxModel getHeaderExtensionsModel() {
        return new DefaultComboBoxModel(new Vector(this.headerExtensions.getValues()));
    }

    private static String getFileName(String string) {
        return string;
    }

    public String getClassName() {
        return this.classNameTextField.getText().trim();
    }

    public String getHeaderExt() {
        return this.headerExt;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel5 = new JLabel();
        this.cbSourceExtension = new JComboBox();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel8 = new JLabel();
        this.headerFolderTextField = new JTextField();
        this.headerBrowseButton = new JButton();
        this.jLabel7 = new JLabel();
        this.cbHeaderExtension = new JComboBox();
        this.jLabel6 = new JLabel();
        this.headerTextField = new JTextField();
        this.classNameLbl = new JLabel();
        this.classNameTextField = new JTextField();
        this.setPreferredSize(new Dimension(400, 400));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectTextField);
        this.jLabel1.setText(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        this.projectTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 4, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_locationComboBox"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_Sorce_File_Section")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel2.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName("");
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_browseButton"));
        this.jLabel5.setLabelFor(this.cbSourceExtension);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_Extension_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.cbSourceExtension.setModel(this.getSourceExtensionsModel());
        this.cbSourceExtension.setMinimumSize(new Dimension(100, 25));
        this.cbSourceExtension.setPreferredSize(new Dimension(100, 25));
        this.cbSourceExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCndClassPanelGUI.this.cbSourceExtensionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.cbSourceExtension, gridBagConstraints);
        this.jLabel4.setLabelFor(this.fileTextField);
        this.jLabel4.setText(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        this.fileTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_Heder_File_Section")));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel8.setLabelFor(this.headerFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_HeaderChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel3.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel3.add((Component)this.headerFolderTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.headerBrowseButton, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_HeaderChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel3.add((Component)this.headerBrowseButton, gridBagConstraints);
        this.jLabel7.setLabelFor(this.cbHeaderExtension);
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_HeaderChooser_Extension_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel3.add((Component)this.jLabel7, gridBagConstraints);
        this.cbHeaderExtension.setModel(this.getHeaderExtensionsModel());
        this.cbHeaderExtension.setMinimumSize(new Dimension(100, 25));
        this.cbHeaderExtension.setPreferredSize(new Dimension(100, 25));
        this.cbHeaderExtension.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NewCndClassPanelGUI.this.cbHeaderExtensionActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel3.add((Component)this.cbHeaderExtension, gridBagConstraints);
        this.jLabel6.setLabelFor(this.headerTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_HeaderFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel3.add((Component)this.jLabel6, gridBagConstraints);
        this.headerTextField.setEditable(false);
        this.headerTextField.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel3.add((Component)this.headerTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jPanel3, gridBagConstraints);
        this.classNameLbl.setLabelFor(this.classNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.classNameLbl, (String)NbBundle.getMessage(NewCndClassPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.classNameLbl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.classNameTextField, gridBagConstraints);
        this.classNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_documentNameTextField"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(NewCndClassPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI_1"));
    }

    private void cbSourceExtensionActionPerformed(ActionEvent actionEvent) {
        this.sourceExt = (String)this.cbSourceExtension.getSelectedItem();
        this.updateCreatedFile();
    }

    private void cbHeaderExtensionActionPerformed(ActionEvent actionEvent) {
        this.headerExt = (String)this.cbHeaderExtension.getSelectedItem();
        this.updateCreatedFile();
    }

    private void initMnemonics() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            SourceGroup sourceGroup = this.getTargetGroup();
            FileObject fileObject = BrowseFolders.showDialog(new SourceGroup[]{sourceGroup}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.folderTextField.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.headerBrowseButton == actionEvent.getSource()) {
            SourceGroup sourceGroup = this.getTargetGroup();
            FileObject fileObject = BrowseFolders.showDialog(new SourceGroup[]{sourceGroup}, this.project, this.headerFolderTextField.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.headerFolderTextField.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == actionEvent.getSource()) {
            this.updateCreatedFile();
        }
    }
}

