/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.api.xml.Catalog;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class XMLDocReader
extends XMLDecoder {
    public boolean debug = false;
    private String sourceName;
    private String currentText = null;

    public boolean read(InputStream inputStream, String string) {
        Object object;
        this.sourceName = string;
        if (string == null) {
            this.sourceName = Catalog.get("UNKNOWN_sourceName");
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        XMLReader xMLReader = null;
        try {
            object = sAXParserFactory.newSAXParser();
            xMLReader = ((SAXParser)object).getXMLReader();
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return false;
        }
        object = new Parser();
        xMLReader.setContentHandler((ContentHandler)object);
        xMLReader.setEntityResolver((EntityResolver)object);
        xMLReader.setErrorHandler(new ErrHandler());
        String string2 = Catalog.get("MSG_Whilereading");
        String string3 = MessageFormat.format(string2, string);
        try {
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
        }
        catch (SAXException sAXException) {
            VersionException versionException = null;
            if (sAXException.getException() instanceof VersionException) {
                versionException = (VersionException)sAXException.getException();
            }
            if (versionException != null) {
                String string4 = versionException.element();
                int n = versionException.expectedVersion();
                int n2 = versionException.actualVersion();
                string2 = Catalog.get("MSG_versionerror");
                String string5 = string3 + MessageFormat.format(string2, string4, "" + n2, "" + n);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string5, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            } else {
                ErrorManager.getDefault().annotate((Throwable)sAXException, string3);
                ErrorManager.getDefault().notify((Throwable)sAXException);
            }
            return false;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, string3);
            ErrorManager.getDefault().notify((Throwable)iOException);
            return false;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().annotate((Throwable)exception, string3);
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
            return false;
        }
        return true;
    }

    private static final class ErrHandler
    implements ErrorHandler {
        private void annotate(SAXParseException sAXParseException) {
            String string = Catalog.get("MSG_sax_error_location");
            String string2 = MessageFormat.format(string, sAXParseException.getSystemId(), "" + sAXParseException.getLineNumber());
            ErrorManager.getDefault().annotate((Throwable)sAXParseException, 0, string2, null, null, null);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.annotate(sAXParseException);
            throw sAXParseException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.annotate(sAXParseException);
            throw sAXParseException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            ErrorManager.getDefault().notify(1, (Throwable)sAXParseException);
        }
    }

    private class Parser
    implements ContentHandler,
    EntityResolver {
        private Parser() {
        }

        public InputSource resolveEntity(String string, String string2) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX resolveEntity: " + string + " " + string2);
            }
            byte[] byArray = new byte[]{};
            return new InputSource(new ByteArrayInputStream(byArray));
        }

        public void startDocument() throws SAXException {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX startDocument");
            }
            try {
                XMLDocReader.this.start(null);
            }
            catch (VersionException versionException) {
                throw new SAXException(versionException);
            }
        }

        public void endDocument() {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX endDocument");
            }
            XMLDocReader.this.end();
        }

        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            XMLDocReader.this.currentText = XMLDocReader.this.currentText + string;
            if (XMLDocReader.this.debug) {
                if ((string = string.trim()).length() == 0) {
                    System.out.println("SAX characters[" + n2 + "]: " + "<trimmed>");
                } else {
                    System.out.println("SAX characters[" + n2 + "]: " + string);
                }
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX startElement: " + string + " " + string2 + "/" + string3);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getLocalName(i);
                    String string5 = attributes.getQName(i);
                    String string6 = attributes.getValue(i);
                    System.out.println("SAX\t" + string4 + "/" + string5 + "=" + string6);
                }
            }
            XMLDocReader.this.currentText = "";
            try {
                XMLDocReader.this._startElement(string3, attributes);
            }
            catch (VersionException versionException) {
                throw new SAXException(versionException);
            }
        }

        public void endElement(String string, String string2, String string3) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX endElement: " + string + " " + string2 + " " + string3);
            }
            XMLDocReader.this._endElement(string3, XMLDocReader.this.currentText);
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX endPrefixMapping: " + string);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX ignorableWhitespace " + n2);
            }
        }

        public void processingInstruction(String string, String string2) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX processingInstruction: " + string + " " + string2);
            }
        }

        public void setDocumentLocator(Locator locator) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX setDocumentLocator");
            }
        }

        public void skippedEntity(String string) {
            if (XMLDocReader.this.debug) {
                System.out.println("SAX skippedEntity: " + string);
            }
        }
    }
}

