/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import org.netbeans.modules.cnd.api.utils.SourceFileFilter;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HeaderSourceFileFilter
extends SourceFileFilter {
    private static HeaderSourceFileFilter instance = null;
    private String[] suffixList = null;

    public static HeaderSourceFileFilter getInstance() {
        if (instance == null) {
            instance = new HeaderSourceFileFilter();
        }
        return instance;
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            if (FileUtil.getExtension((String)file.getPath()).length() == 0) {
                return "text/x-h".equals(MIMESupport.getFileMIMEType((File)file));
            }
            return super.accept(file);
        }
        return false;
    }

    public String getDescription() {
        return NbBundle.getMessage(SourceFileFilter.class, (String)"FILECHOOSER_HEADER_SOURCES_FILEFILTER", (Object)this.getSuffixesAsString());
    }

    public String[] getSuffixes() {
        if (this.suffixList == null) {
            this.suffixList = MIMEExtensions.get((String)"text/x-h").getValues().toArray(new String[0]);
        }
        return this.suffixList;
    }
}

