/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.CompilerSetUtils;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

final class CompilerSetPreferences {
    private static final double csm_version = 1.1;
    private static final String CSM = "csm.";
    private static final String VERSION = "version";
    private static final String NO_SETS = ".noOfSets";
    private static final String SET_NAME = ".setName.";
    private static final String SET_FLAVOR = ".setFlavor.";
    private static final String SET_DIRECTORY = ".setDirectory.";
    private static final String SET_AUTO = ".autoGenerated.";
    private static final String SET_DEFAULT = ".defaultSet";
    private static final String SET_PLATFORM = ".setPlatform.";
    private static final String NO_TOOLS = ".noOfTools.";
    private static final String TOOL_NAME = ".toolName.";
    private static final String TOOL_DISPLAYNAME = ".toolDisplayName.";
    private static final String TOOL_KIND = ".toolKind.";
    private static final String TOOL_PATH = ".toolPath.";
    private static final String TOOL_FLAVOR = ".toolFlavor.";
    private static CompilerProvider compilerProvider = null;

    private CompilerSetPreferences() {
    }

    static Preferences getPreferences() {
        return NbPreferences.forModule(CompilerSetPreferences.class);
    }

    static void putEnv(ExecutionEnvironment executionEnvironment, int n) {
        CompilerSetPreferences.getPreferences().putInt(CSM + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment) + SET_PLATFORM, n);
    }

    static void clearPersistence() {
        try {
            CompilerSetPreferences.getPreferences().clear();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    static void saveToDisk(CompilerSetManager compilerSetManager) {
        if (!compilerSetManager.getCompilerSets().isEmpty()) {
            CompilerSetPreferences.getPreferences().putDouble("csm.version", 1.1);
            String string = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)compilerSetManager.getExecutionEnvironment());
            CompilerSetPreferences.getPreferences().putInt(CSM + string + NO_SETS, compilerSetManager.getCompilerSets().size());
            CompilerSetPreferences.getPreferences().putInt(CSM + string + SET_PLATFORM, compilerSetManager.getPlatform());
            int n = 0;
            for (CompilerSet compilerSet : compilerSetManager.getCompilerSets()) {
                CompilerSetPreferences.getPreferences().put(CSM + string + SET_NAME + n, compilerSet.getName());
                CompilerSetPreferences.getPreferences().put(CSM + string + SET_FLAVOR + n, compilerSet.getCompilerFlavor().toString());
                CompilerSetPreferences.getPreferences().put(CSM + string + SET_DIRECTORY + n, compilerSet.getDirectory());
                CompilerSetPreferences.getPreferences().putBoolean(CSM + string + SET_AUTO + n, compilerSet.isAutoGenerated());
                CompilerSetPreferences.getPreferences().putBoolean(CSM + string + SET_DEFAULT + n, compilerSet.isDefault());
                List<Tool> list = compilerSet.getTools();
                CompilerSetPreferences.getPreferences().putInt(CSM + string + NO_TOOLS + n, list.size());
                int n2 = 0;
                for (Tool tool : list) {
                    CompilerSetPreferences.getPreferences().put(CSM + string + TOOL_NAME + n + '.' + n2, tool.getName());
                    CompilerSetPreferences.getPreferences().put(CSM + string + TOOL_DISPLAYNAME + '-' + n + '.' + n2, tool.getDisplayName());
                    CompilerSetPreferences.getPreferences().putInt(CSM + string + TOOL_KIND + n + '.' + n2, tool.getKind());
                    CompilerSetPreferences.getPreferences().put(CSM + string + TOOL_PATH + n + '.' + n2, tool.getPath());
                    CompilerSetPreferences.getPreferences().put(CSM + string + TOOL_FLAVOR + n + '.' + n2, tool.getFlavor().toString());
                    ++n2;
                }
                ++n;
            }
        }
    }

    static CompilerSetManager restoreFromDisk(ExecutionEnvironment executionEnvironment) {
        double d = CompilerSetPreferences.getPreferences().getDouble("csm.version", 1.0);
        if (d == 1.0 && executionEnvironment.isLocal()) {
            return CompilerSetPreferences.restoreFromDisk10();
        }
        String string = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment);
        int n = CompilerSetPreferences.getPreferences().getInt(CSM + string + NO_SETS, -1);
        if (n < 0) {
            return null;
        }
        int n2 = CompilerSetPreferences.getPreferences().getInt(CSM + string + SET_PLATFORM, -1);
        if (n2 < 0 && executionEnvironment.isLocal()) {
            n2 = CompilerSetUtils.computeLocalPlatform();
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        for (int i = 0; i < n; ++i) {
            String string2 = CompilerSetPreferences.getPreferences().get(CSM + string + SET_NAME + i, null);
            String string3 = CompilerSetPreferences.getPreferences().get(CSM + string + SET_FLAVOR + i, null);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string3 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string3, n2);
            }
            String string4 = CompilerSetPreferences.getPreferences().get(CSM + string + SET_DIRECTORY + i, null);
            if (string2 == null || string3 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetPreferences.getPreferences().getBoolean(CSM + string + SET_AUTO + i, false);
            Boolean bl2 = CompilerSetPreferences.getPreferences().getBoolean(CSM + string + SET_DEFAULT + i, false);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string4, string2);
            compilerSet.setAutoGenerated(bl);
            compilerSet.setAsDefault(bl2);
            int n3 = CompilerSetPreferences.getPreferences().getInt(CSM + string + NO_TOOLS + i, -1);
            for (int j = 0; j < n3; ++j) {
                String string5 = CompilerSetPreferences.getPreferences().get(CSM + string + TOOL_NAME + i + '.' + j, null);
                String string6 = CompilerSetPreferences.getPreferences().get(CSM + string + TOOL_DISPLAYNAME + '-' + i + '.' + j, null);
                int n4 = CompilerSetPreferences.getPreferences().getInt(CSM + string + TOOL_KIND + i + '.' + j, -1);
                String string7 = CompilerSetPreferences.getPreferences().get(CSM + string + TOOL_PATH + i + '.' + j, null);
                String string8 = CompilerSetPreferences.getPreferences().get(CSM + string + TOOL_FLAVOR + i + '.' + j, null);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string8 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string8, n2);
                }
                Tool tool = CompilerSetPreferences.getCompilerProvider().createCompiler(executionEnvironment, compilerFlavor2, n4, "", string6, string7);
                tool.setName(string5);
                compilerSet.addTool(tool);
            }
            arrayList.add(compilerSet);
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(executionEnvironment, arrayList, n2);
        return compilerSetManager;
    }

    private static CompilerSetManager restoreFromDisk10() {
        int n = CompilerSetPreferences.getPreferences().getInt("csm..noOfSets", -1);
        if (n < 0) {
            return null;
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        CompilerSetPreferences.getPreferences().remove("csm..noOfSets");
        for (int i = 0; i < n; ++i) {
            String string = CompilerSetPreferences.getPreferences().get("csm..setName." + i, null);
            CompilerSetPreferences.getPreferences().remove("csm..setName." + i);
            String string2 = CompilerSetPreferences.getPreferences().get("csm..setFlavor." + i, null);
            CompilerSetPreferences.getPreferences().remove("csm..setFlavor." + i);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string2 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string2, PlatformTypes.getDefaultPlatform());
            }
            String string3 = CompilerSetPreferences.getPreferences().get("csm..setDirectory." + i, null);
            CompilerSetPreferences.getPreferences().remove("csm..setDirectory." + i);
            if (string == null || string2 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetPreferences.getPreferences().getBoolean("csm..autoGenerated." + i, false);
            CompilerSetPreferences.getPreferences().remove("csm..autoGenerated." + i);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string3, string);
            compilerSet.setAutoGenerated(bl);
            int n2 = CompilerSetPreferences.getPreferences().getInt("csm..noOfTools." + i, -1);
            CompilerSetPreferences.getPreferences().remove("csm..noOfTools." + i);
            for (int j = 0; j < n2; ++j) {
                String string4 = CompilerSetPreferences.getPreferences().get("csm..toolName." + i + '.' + j, null);
                String string5 = CompilerSetPreferences.getPreferences().get("csm..toolDisplayName.-" + i + '.' + j, null);
                int n3 = CompilerSetPreferences.getPreferences().getInt("csm..toolKind." + i + '.' + j, -1);
                String string6 = CompilerSetPreferences.getPreferences().get("csm..toolPath." + i + '.' + j, null);
                String string7 = CompilerSetPreferences.getPreferences().get("csm..toolFlavor." + i + '.' + j, null);
                CompilerSetPreferences.getPreferences().remove("csm..toolName." + i + '.' + j);
                CompilerSetPreferences.getPreferences().remove("csm..toolDisplayName.-" + i + '.' + j);
                CompilerSetPreferences.getPreferences().remove("csm..toolKind." + i + '.' + j);
                CompilerSetPreferences.getPreferences().remove("csm..toolPath." + i + '.' + j);
                CompilerSetPreferences.getPreferences().remove("csm..toolFlavor." + i + '.' + j);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string7 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string7, PlatformTypes.getDefaultPlatform());
                }
                Tool tool = CompilerSetPreferences.getCompilerProvider().createCompiler(ExecutionEnvironmentFactory.getLocal(), compilerFlavor2, n3, "", string5, string6);
                tool.setName(string4);
                compilerSet.addTool(tool);
            }
            CompilerSetManager.completeCompilerSet(ExecutionEnvironmentFactory.getLocal(), compilerSet, arrayList);
            arrayList.add(compilerSet);
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(ExecutionEnvironmentFactory.getLocal(), arrayList, CompilerSetUtils.computeLocalPlatform());
        return compilerSetManager;
    }

    static CompilerProvider getCompilerProvider() {
        if (compilerProvider == null) {
            compilerProvider = CompilerProvider.getInstance();
        }
        return compilerProvider;
    }
}

