/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.compilers.CompilerSetUtils;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.execution.LinkSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.loaders.ShellDataObject;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellRunAction
extends AbstractExecutorRunAction {
    public String getName() {
        return ShellRunAction.getString("BTN_Run");
    }

    @Override
    protected boolean accept(DataObject dataObject) {
        return dataObject instanceof ShellDataObject;
    }

    protected void performAction(Node[] nodeArray) {
        LifecycleManager.getDefault().saveAll();
        for (int i = 0; i < nodeArray.length; ++i) {
            ShellRunAction.performAction(nodeArray[i]);
        }
    }

    public static void performAction(Node node) {
        ShellRunAction.performAction(node, null, null, ShellRunAction.getProject(node), null);
    }

    public static Future<Integer> performAction(final Node node, final ExecutionListener executionListener, final Writer writer, final Project project, final InputOutput inputOutput) {
        if (!SwingUtilities.isEventDispatchThread()) {
            return ShellRunAction._performAction(node, executionListener, writer, project, inputOutput);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                ShellRunAction._performAction(node, executionListener, writer, project, inputOutput);
            }
        });
        return null;
    }

    private static Future<Integer> _performAction(Node node, ExecutionListener executionListener, Writer writer, Project project, InputOutput inputOutput) {
        InputOutput inputOutput2;
        Object object;
        Object object2;
        int n;
        ShellExecSupport shellExecSupport = (ShellExecSupport)node.getCookie(ShellExecSupport.class);
        if (shellExecSupport == null) {
            return null;
        }
        ShellRunAction.saveNode(node);
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = shellExecSupport.getRunDirectory();
        String string2 = ShellRunAction.getAbsoluteBuildDir(string, file).getAbsolutePath();
        String[] stringArray = shellExecSupport.getShellCommandAndArgs(fileObject);
        String string3 = stringArray[0];
        String string4 = IpeUtils.toRelativePath(string2, file.getPath());
        if (string4.equals(file.getName())) {
            string4 = "." + File.separatorChar + string4;
        }
        String[] stringArray2 = shellExecSupport.getArguments();
        ExecutionEnvironment executionEnvironment = ShellRunAction.getExecutionEnvironment(fileObject, project);
        string2 = ShellRunAction.convertToRemoteIfNeeded(executionEnvironment, string2);
        if (string2 == null) {
            return null;
        }
        string4 = ShellRunAction.convertToRemoveSeparatorsIfNeeded(executionEnvironment, string4);
        if (PlatformInfo.getDefault(executionEnvironment).isWindows() && string3.length() > 0) {
            string3 = ShellRunAction.findWindowsShell(string3, executionEnvironment, node);
            string3 = LinkSupport.resolveWindowsLink(string3);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray[0].length() > 0) {
            for (n = 1; n < stringArray.length; ++n) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[n]);
            }
        }
        if (string3.length() == 0) {
            string3 = file.getAbsolutePath();
        } else {
            stringBuilder.append(string4);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringBuilder.append(" ");
            stringBuilder.append(stringArray2[n]);
        }
        Map<String, String> map = ShellRunAction.getEnv(executionEnvironment, node, null);
        ShellRunAction.traceExecutable(string3, string2, stringBuilder, map);
        if (inputOutput == null) {
            object2 = ShellRunAction.getString("RUN_LABEL", node.getName());
            object = IOProvider.getDefault().getIO((String)object2, false);
            object.closeInputOutput();
            inputOutput2 = IOProvider.getDefault().getIO((String)object2, true);
            try {
                inputOutput2.getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputOutput = inputOutput2;
        }
        if ((object2 = RemoteSyncSupport.createSyncWorker((Project)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !object2.startup(map)) {
            return null;
        }
        object = new AbstractExecutorRunAction.ProcessChangeListener(executionListener, writer, null, inputOutput, "Run", (RemoteSyncWorker)object2);
        inputOutput2 = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment).setWorkingDirectory(string2).unbufferOutput(false).addNativeProcessListener((ChangeListener)object);
        inputOutput2.getEnvironment().putAll(map);
        inputOutput2.redirectError();
        List<String> list = ImportUtils.parseArgs(stringBuilder.toString());
        list = ImportUtils.normalizeParameters(list);
        inputOutput2.setExecutable(string3);
        inputOutput2.setArguments(list.toArray(new String[list.size()]));
        ExecutionDescriptor executionDescriptor = new ExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).outLineBased(true).showProgress(true).postExecution((Runnable)object).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)object).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)object);
        ExecutionService executionService = ExecutionService.newService((Callable)inputOutput2, (ExecutionDescriptor)executionDescriptor, (String)"Run");
        return executionService.run();
    }

    private static String findWindowsShell(String string, ExecutionEnvironment executionEnvironment, Node node) {
        Object object;
        CompilerSetManager compilerSetManager;
        File file;
        int n = string.lastIndexOf("/");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((file = new File(string)).exists()) {
            return string;
        }
        PlatformInfo platformInfo = PlatformInfo.getDefault(executionEnvironment);
        String string2 = platformInfo.findCommand(string);
        if (string2 != null) {
            return string2;
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        CompilerSet compilerSet = ShellRunAction.getCompilerSet(node);
        if (compilerSet != null) {
            arrayList.add(compilerSet);
        }
        if ((compilerSetManager = CompilerSetManager.getDefault(executionEnvironment)) != null) {
            compilerSet = compilerSetManager.getDefaultCompilerSet();
            if (compilerSet != null && !arrayList.contains(compilerSet)) {
                arrayList.add(compilerSet);
            }
            for (CompilerSet object2 : compilerSetManager.getCompilerSets()) {
                if (object2 == null || arrayList.contains(object2)) continue;
                arrayList.add(object2);
            }
        }
        for (CompilerSet compilerSet2 : arrayList) {
            object = compilerSet2.getCompilerFlavor().getCommandFolder(3);
            if (!(object != null ? (string2 = platformInfo.findCommand((String)object, string)) != null : (object = compilerSet2.getDirectory()) != null && (string2 = platformInfo.findCommand((String)object, string)) != null)) continue;
            return string2;
        }
        object = CompilerSetUtils.getCygwinBase();
        if (object != null && (string2 = platformInfo.findCommand((String)object, string)) != null) {
            return string2;
        }
        object = CompilerSetUtils.getMSysBase();
        if (object != null && (string2 = platformInfo.findCommand((String)object, string)) != null) {
            return string2;
        }
        return string;
    }
}

