/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.nodes;

import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.spi.SaasNodeActionsProvider;
import org.netbeans.modules.websvc.saas.ui.actions.DeleteServiceAction;
import org.netbeans.modules.websvc.saas.ui.actions.RefreshServiceAction;
import org.netbeans.modules.websvc.saas.ui.actions.ViewApiDocAction;
import org.netbeans.modules.websvc.saas.ui.nodes.SaasNodeChildren;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SaasNode
extends AbstractNode {
    protected Saas saas;

    public SaasNode(SaasNodeChildren saasNodeChildren, AbstractLookup abstractLookup, Saas saas) {
        super((Children)saasNodeChildren, (Lookup)abstractLookup);
        this.saas = saas;
    }

    public Saas getSaas() {
        return this.saas;
    }

    public String getDisplayName() {
        return this.saas.getDisplayName();
    }

    public String getShortDescription() {
        return this.saas.getDescription();
    }

    public Image getIcon(int n) {
        return this.getGenericIcon(n);
    }

    protected abstract Image getGenericIcon(int var1);

    public static List<Action> getActions(Lookup lookup) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (SaasNodeActionsProvider saasNodeActionsProvider : SaasUtil.getSaasNodeActionsProviders()) {
            for (Action action : saasNodeActionsProvider.getSaasActions(lookup)) {
                arrayList.add(action);
            }
        }
        return arrayList;
    }

    public Action[] getActions(boolean bl) {
        List<Action> list = SaasNode.getActions(this.getLookup());
        list.add((Action)SystemAction.get(ViewApiDocAction.class));
        list.add((Action)SystemAction.get(DeleteServiceAction.class));
        list.add((Action)SystemAction.get(RefreshServiceAction.class));
        return list.toArray(new Action[list.size()]);
    }

    public void destroy() throws IOException {
        SaasServicesModel.getInstance().removeService(this.getSaas());
        super.destroy();
    }

    public boolean canDestroy() {
        return this.getSaas().isUserDefined();
    }
}

