/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(GroovyEmbeddingProvider.class.getName());

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if ("text/x-gsp".equals(snapshot.getMimeType())) {
            List<Embedding> list = this.translate(snapshot);
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(list));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + "text/x-gsp" + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    private static TokenSequence<? extends TokenId> getTokenSequence(Snapshot snapshot) {
        Language language = Language.find((String)snapshot.getMimeType());
        if (language != null) {
            return TokenHierarchy.create((CharSequence)snapshot.getText(), (Language)language).tokenSequence();
        }
        return null;
    }

    private List<Embedding> translate(Snapshot snapshot) {
        TokenSequence<? extends TokenId> tokenSequence = GroovyEmbeddingProvider.getTokenSequence(snapshot);
        if (tokenSequence == null) {
            return Collections.emptyList();
        }
        ArrayList<Embedding> arrayList = new ArrayList<Embedding>();
        TokenSequence<? extends TokenId> tokenSequence2 = tokenSequence;
        this.translate(snapshot, tokenSequence2, arrayList);
        return arrayList;
    }

    private void translate(Snapshot snapshot, TokenSequence<? extends GspTokenId> tokenSequence, List<Embedding> list) {
        list.add(snapshot.create((CharSequence)"def _buf ='';", "text/x-groovy"));
        boolean bl = false;
        while (tokenSequence.moveNext()) {
            int n;
            CharSequence charSequence;
            int n2;
            Token token = tokenSequence.token();
            if (token.id() == GspTokenId.HTML) {
                int n3;
                n2 = tokenSequence.offset();
                int n4 = n2 + token.length();
                charSequence = token.text();
                String string = charSequence == null ? "" : ((Object)charSequence).toString();
                n = 0;
                for (n3 = 0; n3 < string.length(); ++n3) {
                    char c = string.charAt(n3);
                    if (c == '\n') {
                        ++n3;
                        n = 1;
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                if (n != 0) {
                    list.add(snapshot.create(n2, n3, "text/x-groovy"));
                    string = string.substring(n3);
                }
                list.add(snapshot.create((CharSequence)"_buf += \"\"\"", "text/x-groovy"));
                if (bl && string.startsWith("\n")) {
                    string = string.substring(1);
                    --n4;
                }
                list.add(snapshot.create((CharSequence)string.replace("\"", "\\\""), "text/x-groovy"));
                list.add(snapshot.create((CharSequence)"\"\"\";", "text/x-groovy"));
                bl = false;
                continue;
            }
            if (token.id() == GspTokenId.GROOVY) {
                n2 = tokenSequence.offset();
                String string = ((Object)token.text()).toString();
                charSequence = string.trim();
                if (((String)charSequence).startsWith("--") && ((String)charSequence).endsWith("--")) {
                    int n5 = string.indexOf("--");
                    if (n5 != (n = string.lastIndexOf("--")) && n - 2 > 0) {
                        list.add(snapshot.create((CharSequence)"/*", "text/x-groovy"));
                        list.add(snapshot.create(n2 + n5 + 2, n - 2, "text/x-groovy"));
                        list.add(snapshot.create((CharSequence)"*/", "text/x-groovy"));
                    }
                } else {
                    list.add(snapshot.create(n2, string.length(), "text/x-groovy"));
                    list.add(snapshot.create((CharSequence)";", "text/x-groovy"));
                }
                bl = false;
                bl = false;
                continue;
            }
            if (token.id() != GspTokenId.GROOVY_EXPR) continue;
            list.add(snapshot.create((CharSequence)"_buf += (", "text/x-groovy"));
            n2 = tokenSequence.offset();
            String string = ((Object)token.text()).toString();
            bl = false;
            list.add(snapshot.create(n2, string.length(), "text/x-groovy"));
            list.add(snapshot.create((CharSequence)";)", "text/x-groovy"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (!"text/x-gsp".equals(snapshot.getMimeType())) {
                return Collections.emptyList();
            }
            return Collections.singleton(new GroovyEmbeddingProvider());
        }
    }
}

