/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CodeCompletionHandler;
import org.netbeans.modules.csl.api.CodeCompletionResult;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.editor.api.completion.CompletionHandler;
import org.netbeans.modules.groovy.gsp.lexer.GspTokenId;

public class GspCompleter
extends CompletionHandler {
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        ParserResult parserResult = codeCompletionContext.getParserResult();
        int n = codeCompletionContext.getCaretOffset();
        Document document = parserResult.getSnapshot().getSource().getDocument(false);
        if (document != null && GspCompleter.isWithinGroovy(document, n)) {
            return super.complete(codeCompletionContext);
        }
        return CodeCompletionResult.NONE;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        int n;
        Document document = jTextComponent.getDocument();
        if (GspCompleter.isWithinGroovy(document, n = jTextComponent.getCaret().getDot())) {
            return super.getAutoQuery(jTextComponent, string);
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    static boolean isWithinGroovy(Document document, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == GspTokenId.GROOVY || tokenId == GspTokenId.GROOVY_EXPR) {
                return true;
            }
            if (tokenId == GspTokenId.DELIMITER) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == GspTokenId.GROOVY || tokenSequence.token().id() == GspTokenId.GROOVY_EXPR) {
                    return true;
                }
            }
        }
        return false;
    }
}

