/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.mobility.antext.Base64;
import org.netbeans.mobility.antext.Bundle;

public class JadTask
extends Task {
    private static final String[] TEST_KEYS = new String[]{"MicroEdition-Configuration", "MicroEdition-Profile", "MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"};
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String JAR_URL_KEY = "MIDlet-Jar-URL";
    private static final String JAR_SIZE_KEY = "MIDlet-Jar-Size";
    private static final String JAR_RSA_SHA1 = "MIDlet-Jar-RSA-SHA1";
    private static final String CERTIFICATE = "MIDlet-Certificate-{0}-{1}";
    private static final String SHA1withRSA = "SHA1withRSA";
    private static final String MIDLET_1 = "MIDlet-1";
    private static final String PKCS12 = "PKCS12";
    private File jadFile;
    private File jarFile;
    private File output;
    private String url;
    private String encoding;
    private boolean sign = false;
    private File keyStore = null;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String alias = null;
    private String aliasPassword = null;
    private static final String ERR_MissingAttr = "ERR_MissingAttr";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File file;
        if (this.jadFile == null) {
            throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "jadFile"));
        }
        if (this.jarFile == null) {
            throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "jarFile"));
        }
        File file2 = this.jadFile;
        File file3 = file = this.output != null ? this.output : this.jadFile;
        if (!file2.isFile()) {
            throw new BuildException(Bundle.getMessage("ERR_SourceIsMissing", file2.toString()));
        }
        if (!this.jarFile.isFile()) {
            throw new BuildException(Bundle.getMessage("ERR_JarFileIsMissing", this.jarFile.toString()));
        }
        try {
            Object object;
            this.log(Bundle.getMessage("MSG_Updating", file.getAbsolutePath()), 2);
            this.log(Bundle.getMessage("MSG_Loading", file2.toString()), 3);
            HashMap<Object, String> hashMap = new HashMap<Object, String>();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), this.encoding != null ? this.encoding : DEFAULT_ENCODING));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if ("".equals(string) || string.startsWith("#")) continue;
                    int n = string.indexOf(58);
                    if (n < 0) {
                        this.log(Bundle.getMessage("WARN_InvalidLineFormat", string), 1);
                        continue;
                    }
                    hashMap.put(string.substring(0, n), string.substring(n + 1).trim());
                }
            }
            finally {
                bufferedReader.close();
            }
            if (!hashMap.containsKey(MIDLET_1)) {
                this.log(Bundle.getMessage("WARN_MissingMIDlets"), 1);
            }
            for (int i = 0; i < TEST_KEYS.length; ++i) {
                if (hashMap.containsKey(TEST_KEYS[i])) continue;
                this.log(Bundle.getMessage("WARN_MissingAttribute", TEST_KEYS[i]), 1);
            }
            if (this.url == null) {
                if (!hashMap.containsKey(JAR_URL_KEY)) {
                    String string = this.jarFile.getName();
                    this.log(Bundle.getMessage("WARN_MissingURL", JAR_URL_KEY, string), 1);
                    hashMap.put(JAR_URL_KEY, string);
                }
            } else {
                this.log(Bundle.getMessage("MSG_SettingAttribute", JAR_URL_KEY, this.url), 3);
                hashMap.put(JAR_URL_KEY, this.url);
            }
            String string = String.valueOf(this.jarFile.length());
            this.log(Bundle.getMessage("MSG_JarSize", this.jarFile.getAbsolutePath(), string), 2);
            this.log(Bundle.getMessage("MSG_SettingAttribute", JAR_SIZE_KEY, string), 3);
            hashMap.put(JAR_SIZE_KEY, string);
            if (this.sign) {
                Signature signature;
                Object object2;
                Object object3;
                Key key;
                Certificate[] certificateArray;
                KeyStore keyStore;
                if (this.keyStore == null || !this.keyStore.exists() || !this.keyStore.isFile()) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, this.keyStore == null ? "keystore" : this.keyStore.getAbsolutePath()));
                }
                if (this.keyStorePassword == null) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "keyStorePassword"));
                }
                if (this.alias == null) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "alias"));
                }
                if (this.aliasPassword == null) {
                    throw new BuildException(Bundle.getMessage(ERR_MissingAttr, "aliasPassword"));
                }
                this.log(Bundle.getMessage("MSG_Signing"), 2);
                try {
                    if (this.keyStoreType == null && (((String)(object = this.keyStore.getAbsolutePath().toLowerCase())).endsWith(".p12") || ((String)object).endsWith(".pkcs12"))) {
                        this.keyStoreType = PKCS12;
                    }
                    keyStore = this.keyStoreType != null && PKCS12.equals(this.keyStoreType) ? KeyStore.getInstance("pkcs12", "SunJSSE") : KeyStore.getInstance("JKS", "SUN");
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new BuildException(Bundle.getMessage("ERR_UnsupportedKeyStoreProvider", this.keyStoreType != null ? this.keyStoreType : "default"), (Throwable)noSuchProviderException);
                }
                catch (KeyStoreException keyStoreException) {
                    throw new BuildException(Bundle.getMessage("ERR_UnsupportedKeyStoreType", this.keyStoreType != null ? this.keyStoreType : "default"), (Throwable)keyStoreException);
                }
                object = new FileInputStream(this.keyStore);
                try {
                    keyStore.load((InputStream)object, this.keyStorePassword.toCharArray());
                }
                catch (IOException iOException) {
                    throw new BuildException(Bundle.getMessage("ERR_ErrorLoadingKeyStore", this.keyStore.getAbsolutePath()), (Throwable)iOException);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new BuildException(Bundle.getMessage("ERR_ErrorLoadingKeyStore", this.keyStore.getAbsolutePath()), (Throwable)noSuchAlgorithmException);
                }
                catch (CertificateException certificateException) {
                    throw new BuildException(Bundle.getMessage("ERR_ErrorLoadingKeyStore", this.keyStore.getAbsolutePath()), (Throwable)certificateException);
                }
                finally {
                    ((InputStream)object).close();
                }
                hashMap.remove(JAR_RSA_SHA1);
                int n = 1;
                while (true) {
                    int n2 = 1;
                    while (hashMap.remove(MessageFormat.format(CERTIFICATE, Integer.toString(n), Integer.toString(n2))) != null) {
                        ++n2;
                    }
                    if (n2 <= 1) break;
                    ++n;
                }
                try {
                    certificateArray = keyStore.getCertificateChain(this.alias);
                    key = keyStore.getKey(this.alias, this.aliasPassword.toCharArray());
                }
                catch (UnrecoverableKeyException unrecoverableKeyException) {
                    unrecoverableKeyException.printStackTrace();
                    certificateArray = null;
                    key = null;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    noSuchAlgorithmException.printStackTrace();
                    certificateArray = null;
                    key = null;
                }
                catch (KeyStoreException keyStoreException) {
                    keyStoreException.printStackTrace();
                    certificateArray = null;
                    key = null;
                }
                if (certificateArray == null || key == null) {
                    throw new BuildException(Bundle.getMessage("ERR_NoCertificateOrAlgorithm", this.alias));
                }
                for (int i = 0; i < certificateArray.length; ++i) {
                    object3 = certificateArray[i];
                    object2 = MessageFormat.format(CERTIFICATE, "1", Integer.toString(i + 1));
                    this.log(Bundle.getMessage("MSG_AddingCertificateAttr", (String)object2), 3);
                    try {
                        hashMap.put(object2, Base64.encode(((Certificate)object3).getEncoded()));
                        continue;
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new BuildException(Bundle.getMessage("ERR_CertificateEncoding"), (Throwable)certificateEncodingException);
                    }
                }
                try {
                    signature = Signature.getInstance(SHA1withRSA);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new BuildException(Bundle.getMessage("ERR_NoSuchAlgorithmException", SHA1withRSA), (Throwable)noSuchAlgorithmException);
                }
                try {
                    if (!(key instanceof PrivateKey)) {
                        key = null;
                    }
                    signature.initSign((PrivateKey)key);
                }
                catch (InvalidKeyException invalidKeyException) {
                    key = null;
                }
                if (key == null) {
                    throw new BuildException(Bundle.getMessage("ERR_InvalidPrivateKey", this.alias));
                }
                object3 = new byte[16384];
                object2 = new FileInputStream(this.jarFile);
                try {
                    int n3;
                    while ((n3 = ((FileInputStream)object2).read((byte[])object3)) >= 0) {
                        if (n3 < 0) continue;
                        signature.update((byte[])object3, 0, n3);
                    }
                    byte[] byArray = signature.sign();
                    this.log(Bundle.getMessage("MSG_AddingSignAttr", JAR_RSA_SHA1), 2);
                    hashMap.put(JAR_RSA_SHA1, Base64.encode(byArray));
                }
                catch (SignatureException signatureException) {
                    throw new BuildException((Throwable)signatureException);
                }
                finally {
                    ((FileInputStream)object2).close();
                }
            }
            this.log(Bundle.getMessage("MSG_Saving", file.toString()), 3);
            PrintStream printStream = new PrintStream((OutputStream)new FileOutputStream(file), false, this.encoding == null ? DEFAULT_ENCODING : this.encoding);
            object = hashMap.keySet().toArray();
            if (object != null) {
                Arrays.sort((Object[])object);
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    printStream.println(object[i] + ": " + (String)hashMap.get(object[i]));
                }
            }
            printStream.flush();
            printStream.close();
        }
        catch (IOException iOException) {
            throw new BuildException((Throwable)iOException);
        }
    }

    public void setJadFile(File file) {
        this.jadFile = file;
    }

    public void setJarFile(File file) {
        this.jarFile = file;
    }

    public void setOutput(File file) {
        this.output = file;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setSign(boolean bl) {
        this.sign = bl;
    }

    public void setKeyStore(File file) {
        this.keyStore = file;
    }

    public void setKeyStoreType(String string) {
        this.keyStoreType = string.toUpperCase();
    }

    public void setKeyStorePassword(String string) {
        this.keyStorePassword = string;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setAliasPassword(String string) {
        this.aliasPassword = string;
    }
}

