/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private Set<CacheItem> cache;
    private volatile boolean isCanceled = false;
    private final TypeElementFinder.Customizer customizer;
    private ClasspathInfo cpInfo;
    private static final Level LEVEL = Level.FINE;
    private static Logger log = Logger.getLogger(JavaTypeProvider.class.getName());

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.isCanceled = false;
        this.setCache(null);
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo classpathInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = classpathInfo;
        this.customizer = customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result result) {
        Object object;
        Object object22;
        Iterator iterator;
        Object object3;
        Set<CacheItem> set;
        ClassIndex.NameKind nameKind;
        this.isCanceled = false;
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        boolean bl = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        switch (searchType) {
            case EXACT_NAME: {
                nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                nameKind = ClassIndex.NameKind.PREFIX;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case REGEXP: {
                nameKind = ClassIndex.NameKind.REGEXP;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case CAMEL_CASE: {
                nameKind = ClassIndex.NameKind.CAMEL_CASE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search type: " + searchType);
            }
        }
        Future future = OpenProjects.getDefault().openProjects();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.fine(interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            LOGGER.fine(executionException.getMessage());
        }
        if (this.getCache() == null) {
            set = null;
            if (this.cpInfo == null) {
                set = new HashSet<CacheItem>();
                object3 = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
                Iterator object52 = object3.iterator();
                while (object52.hasNext()) {
                    iterator = (FileObject)object52.next();
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        object22 = iterator.getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        continue;
                    }
                    ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{object22}));
                    if (this.isCanceled) {
                        return;
                    }
                    set.add(new CacheItem((URL)object22, classpathInfo, false));
                }
                Collection bl2 = QuerySupport.findRoots((Project)null, Collections.emptySet(), Collections.emptySet(), Arrays.asList("classpath/compile", "classpath/boot"));
                for (Object object22 : bl2) {
                    URL uRL;
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        uRL = object22.getURL();
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        continue;
                    }
                    if (!bl && (object = SourceForBinaryQuery.findSourceRoots((URL)uRL)).getRoots().length == 0) continue;
                    object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{object22}), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    set.add(new CacheItem(uRL, (ClasspathInfo)object, true));
                }
            } else {
                object3 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).entries();
                List list = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).entries();
                iterator = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries();
                set = new HashSet<CacheItem>(object3.size() + list.size() + iterator.size());
                object22 = object3.iterator();
                while (object22.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)object22.next();
                    object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{entry.getURL()}), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    set.add(new CacheItem(entry.getURL(), (ClasspathInfo)object, true));
                }
                for (ClassPath.Entry entry : list) {
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{entry.getURL()}), (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    set.add(new CacheItem(entry.getURL(), (ClasspathInfo)object, true));
                }
                object22 = iterator.iterator();
                while (object22.hasNext()) {
                    ClassPath.Entry entry = (ClassPath.Entry)object22.next();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[]{entry.getURL()}));
                    if (this.isCanceled) {
                        return;
                    }
                    set.add(new CacheItem(entry.getURL(), (ClasspathInfo)object, false));
                }
            }
            if (!this.isCanceled) {
                if (LOGGER.isLoggable(LEVEL)) {
                    LOGGER.log(LEVEL, "Querying following roots:");
                    for (CacheItem cacheItem : set) {
                        try {
                            LOGGER.log(LEVEL, "  {0}; binary={1}", new Object[]{cacheItem.getRoot().getURL(), cacheItem.isBinary()});
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {}
                    }
                    LOGGER.log(LEVEL, "-------------------------");
                }
                this.setCache(set);
            } else {
                return;
            }
        }
        if ((set = this.getCache()) == null) {
            return;
        }
        object3 = new ArrayList(set.size() * 20);
        boolean bl2 = SourceUtils.isScanInProgress();
        if (bl2) {
            iterator = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning");
            result.setMessage((String)((Object)iterator));
        } else {
            result.setMessage(null);
        }
        switch (nameKind) {
            case REGEXP: 
            case CASE_INSENSITIVE_REGEXP: {
                string = JavaTypeProvider.removeNonJavaChars(string);
                object22 = searchType == SearchType.CASE_INSENSITIVE_EXACT_NAME ? string : string + "*";
                object22 = ((String)object22).replace("*", ".*").replace('?', '.');
                iterator = object22;
                break;
            }
            default: {
                iterator = string;
            }
        }
        LOGGER.fine("Text For Query '" + string + "'.");
        if (this.customizer != null) {
            set = this.getCache();
            if (set != null) {
                for (CacheItem cacheItem : set) {
                    object = this.customizer.query(cacheItem.classpathInfo, (String)((Object)iterator), nameKind, (Set<ClassIndex.SearchScope>)EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        ElementHandle elementHandle = (ElementHandle)iterator2.next();
                        JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)elementHandle);
                        ((ArrayList)object3).add(javaTypeDescription);
                        if (!this.isCanceled) continue;
                        return;
                    }
                }
            }
        } else {
            boolean bl3;
            ClassIndexManager.getDefault().addClassIndexManagerListener(new ClassIndexManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void classIndexAdded(ClassIndexManagerEvent classIndexManagerEvent) {
                    JavaTypeProvider javaTypeProvider = JavaTypeProvider.this;
                    synchronized (javaTypeProvider) {
                        JavaTypeProvider.this.notify();
                    }
                }

                public void classIndexRemoved(ClassIndexManagerEvent classIndexManagerEvent) {
                }
            });
            do {
                if ((set = this.getCache()) == null) {
                    return;
                }
                for (CacheItem cacheItem : this.getCache()) {
                    object = cacheItem.classpathInfo.getClassIndex().getDeclaredTypes(iterator, nameKind, EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                    Iterator iterator3 = object.iterator();
                    while (iterator3.hasNext()) {
                        ElementHandle elementHandle = (ElementHandle)iterator3.next();
                        JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)elementHandle);
                        ((ArrayList)object3).add(javaTypeDescription);
                        if (!this.isCanceled) continue;
                        return;
                    }
                }
                if (((ArrayList)object3).isEmpty() && bl3) {
                    try {
                        object22 = this;
                        synchronized (object22) {
                            this.wait(2000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
                if (!this.isCanceled) continue;
                return;
            } while ((bl3 = SourceUtils.isScanInProgress()) && ((ArrayList)object3).isEmpty());
        }
        if (!this.isCanceled) {
            result.addResult(object3);
        }
    }

    private static String removeNonJavaChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private Set<CacheItem> getCache() {
        if (this.cache == null && log.isLoggable(LEVEL)) {
            log.log(LEVEL, "Returning null cache entries.", new Exception());
        }
        return this.cache;
    }

    private void setCache(Set<CacheItem> set) {
        if (log.isLoggable(LEVEL)) {
            log.log(LEVEL, "Setting cache entries from " + this.cache + " to " + set + ".", new Exception());
        }
        this.cache = set;
    }

    static class CacheItem {
        public final boolean isBinary;
        public final URL root;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;
        private ClassPath.Entry defEntry;
        private FileObject cachedRoot;

        public CacheItem(URL uRL, ClasspathInfo classpathInfo, boolean bl) {
            this.isBinary = bl;
            this.root = uRL;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.root == null ? 0 : this.root.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheItem) {
                CacheItem cacheItem = (CacheItem)object;
                return this.root == null ? cacheItem.root == null : this.root.equals(cacheItem.root);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getRoot() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.cachedRoot != null) {
                    return this.cachedRoot;
                }
            }
            cacheItem = URLMapper.findFileObject((URL)this.root);
            CacheItem cacheItem2 = this;
            synchronized (cacheItem2) {
                if (this.cachedRoot == null) {
                    this.cachedRoot = cacheItem;
                }
            }
            return cacheItem;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            try {
                Project project = FileOwnerQuery.getOwner((URI)this.root.toURI());
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    this.projectName = projectInformation.getDisplayName();
                    this.projectIcon = projectInformation.getIcon();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                Exceptions.printStackTrace((Throwable)uRISyntaxException);
            }
        }
    }
}

