/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.mvc.Controller;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.mvc.throwaway.ThrowawayController;

public class ControllerClassNameHandlerMapping
extends AbstractUrlHandlerMapping
implements HandlerMapping {
    private static final String CONTROLLER_SUFFIX = "Controller";
    private Set excludedPackages = Collections.singleton("org.springframework.web.servlet.mvc");
    private Set excludedClasses = Collections.EMPTY_SET;
    private boolean caseSensitive = false;
    private String pathPrefix;
    private String basePackage;

    public void setExcludedPackages(String[] excludedPackages) {
        this.excludedPackages = excludedPackages != null ? new HashSet<String>(Arrays.asList(excludedPackages)) : Collections.EMPTY_SET;
    }

    public void setExcludedClasses(Class[] excludedClasses) {
        this.excludedClasses = excludedClasses != null ? new HashSet<Class>(Arrays.asList(excludedClasses)) : Collections.EMPTY_SET;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setPathPrefix(String prefixPath) {
        this.pathPrefix = prefixPath;
        if (StringUtils.hasLength((String)this.pathPrefix)) {
            if (!this.pathPrefix.startsWith("/")) {
                this.pathPrefix = "/" + this.pathPrefix;
            }
            if (this.pathPrefix.endsWith("/")) {
                this.pathPrefix = this.pathPrefix.substring(0, this.pathPrefix.length() - 1);
            }
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        if (StringUtils.hasLength((String)this.basePackage) && !this.basePackage.endsWith(".")) {
            this.basePackage = this.basePackage + ".";
        }
    }

    protected void initApplicationContext() {
        super.initApplicationContext();
        this.detectControllers();
    }

    protected void detectControllers() throws BeansException {
        this.registerControllers(Controller.class);
        this.registerControllers(ThrowawayController.class);
    }

    protected void registerControllers(Class controllerType) throws BeansException {
        String[] beanNames = this.getApplicationContext().getBeanNamesForType(controllerType);
        for (int i = 0; i < beanNames.length; ++i) {
            String beanName = beanNames[i];
            Class beanClass = this.getApplicationContext().getType(beanName);
            if (!this.isEligibleForMapping(beanName, beanClass)) continue;
            this.registerController(beanName, beanClass);
        }
    }

    protected boolean isEligibleForMapping(String beanName, Class beanClass) {
        if (beanClass == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean type could not be determined"));
            }
            return false;
        }
        if (this.excludedClasses.contains(beanClass)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean class is explicitly excluded: " + beanClass.getName()));
            }
            return false;
        }
        String beanClassName = beanClass.getName();
        Iterator it = this.excludedPackages.iterator();
        while (it.hasNext()) {
            String packageName = (String)it.next();
            if (!beanClassName.startsWith(packageName)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding controller bean '" + beanName + "' from class name mapping " + "because its bean class is defined in an excluded package: " + beanClass.getName()));
            }
            return false;
        }
        return true;
    }

    protected void registerController(String beanName, Class beanClass) throws BeansException, IllegalStateException {
        String urlPath = this.generatePathMapping(beanClass);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering Controller '" + beanName + "' as handler for URL path [" + urlPath + "]"));
        }
        this.registerHandler(urlPath, (Object)beanName);
    }

    protected String generatePathMapping(Class beanClass) {
        String path;
        StringBuffer pathMapping = this.buildPathPrefix(beanClass);
        String className = ClassUtils.getShortName((Class)beanClass);
        String string = path = className.endsWith(CONTROLLER_SUFFIX) ? className.substring(0, className.indexOf(CONTROLLER_SUFFIX)) : className;
        if (path.length() > 0) {
            if (this.caseSensitive) {
                pathMapping.append(path.substring(0, 1).toLowerCase() + path.substring(1));
            } else {
                pathMapping.append(path.toLowerCase());
            }
        }
        if (MultiActionController.class.isAssignableFrom(beanClass)) {
            pathMapping.append("/*");
        } else {
            pathMapping.append("*");
        }
        return pathMapping.toString();
    }

    private StringBuffer buildPathPrefix(Class beanClass) {
        String packageName;
        StringBuffer pathMapping = new StringBuffer();
        if (this.pathPrefix != null) {
            pathMapping.append(this.pathPrefix);
            pathMapping.append("/");
        } else {
            pathMapping.append("/");
        }
        if (this.basePackage != null && (packageName = ClassUtils.getPackageName((Class)beanClass)).startsWith(this.basePackage)) {
            String subPackage = packageName.substring(this.basePackage.length()).replace('.', '/');
            pathMapping.append(this.caseSensitive ? subPackage : subPackage.toLowerCase());
            pathMapping.append("/");
        }
        return pathMapping;
    }
}

