/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.settings.io.jdom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.ActivationFile;
import org.apache.maven.settings.ActivationOS;
import org.apache.maven.settings.ActivationProperty;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryBase;
import org.apache.maven.settings.RepositoryPolicy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.TrackableBase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class SettingsJDOMWriter {
    private DefaultJDOMFactory factory = new DefaultJDOMFactory();
    private String lineSeparator = "\n";

    protected Element findAndReplaceProperties(Counter counter, Element element, String string, Map map) {
        boolean bl = map != null && !map.isEmpty();
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Object object;
            Iterator<Object> iterator = map.keySet().iterator();
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                this.findAndReplaceSimpleElement(counter2, element2, (String)object, (String)map.get(object), null);
            }
            object = new ArrayList(map.keySet());
            iterator = element2.getChildren().iterator();
            while (iterator.hasNext()) {
                Element element3 = (Element)iterator.next();
                String string2 = element3.getName();
                if (((ArrayList)object).contains(string2)) continue;
                iterator.remove();
            }
        }
        return element2;
    }

    protected Element findAndReplaceSimpleElement(Counter counter, Element element, String string, String string2, String string3) {
        Element element2;
        if (string3 != null && string2 != null && string3.equals(string2) && ((element2 = element.getChild(string, element.getNamespace())) != null && string3.equals(element2.getText()) || element2 == null)) {
            return element2;
        }
        boolean bl = string2 != null && string2.trim().length() > 0;
        Element element3 = this.updateElement(counter, element, string, bl);
        if (bl) {
            element3.setText(string2);
        }
        return element3;
    }

    protected Element findAndReplaceSimpleLists(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                String string3 = (String)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                element3.setText(string3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
        return element2;
    }

    protected Element findAndReplaceXpp3DOM(Counter counter, Element element, String string, Xpp3Dom xpp3Dom) {
        boolean bl = xpp3Dom != null && (xpp3Dom.getChildCount() > 0 || xpp3Dom.getValue() != null);
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            this.replaceXpp3DOM(element2, xpp3Dom, new Counter(counter.getDepth() + 1));
        }
        return element2;
    }

    protected void insertAtPreferredLocation(Element element, Element element2, Counter counter) {
        String string;
        int n = 0;
        int n2 = 0;
        Iterator iterator = element.getContent().iterator();
        Text text = null;
        int n3 = 0;
        while (iterator.hasNext() && n2 <= counter.getCurrentIndex()) {
            string = iterator.next();
            ++n3;
            if (string instanceof Element) {
                ++n2;
                n += n3;
                n3 = 0;
            }
            if (!(string instanceof Text) || !iterator.hasNext()) continue;
            text = (Text)string;
        }
        if (text != null && text.getTextTrim().length() == 0) {
            text = (Text)text.clone();
        } else {
            string = this.lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                string = string + "    ";
            }
            text = this.factory.text(string);
        }
        if (element.getContentSize() == 0) {
            string = (Text)text.clone();
            string.setText(string.getText().substring(0, string.getText().length() - "    ".length()));
            element.addContent(n, (Content)string);
        }
        element.addContent(n, (Content)element2);
        element.addContent(n, (Content)text);
    }

    protected void iterateMirror(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Mirror mirror = (Mirror)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateMirror(mirror, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateProfile(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Profile profile = (Profile)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateProfile(profile, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateProxy(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Proxy proxy = (Proxy)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateProxy(proxy, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateRepository(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Repository repository = (Repository)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateRepository(repository, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void iterateServer(Counter counter, Element element, Collection collection, String string, String string2) {
        boolean bl = collection != null && collection.size() > 0;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Iterator iterator = collection.iterator();
            Iterator iterator2 = element2.getChildren(string2, element2.getNamespace()).iterator();
            if (!iterator2.hasNext()) {
                iterator2 = null;
            }
            Counter counter2 = new Counter(counter.getDepth() + 1);
            while (iterator.hasNext()) {
                Element element3;
                Server server = (Server)iterator.next();
                if (iterator2 != null && iterator2.hasNext()) {
                    element3 = (Element)iterator2.next();
                    if (!iterator2.hasNext()) {
                        iterator2 = null;
                    }
                } else {
                    element3 = this.factory.element(string2, element2.getNamespace());
                    this.insertAtPreferredLocation(element2, element3, counter2);
                }
                this.updateServer(server, string2, counter2, element3);
                counter2.increaseCount();
            }
            if (iterator2 != null) {
                while (iterator2.hasNext()) {
                    iterator2.next();
                    iterator2.remove();
                }
            }
        }
    }

    protected void replaceXpp3DOM(Element element, Xpp3Dom xpp3Dom, Counter counter) {
        if (xpp3Dom.getChildCount() > 0) {
            Object object;
            int n;
            Xpp3Dom[] xpp3DomArray = xpp3Dom.getChildren();
            ArrayList<Xpp3Dom> arrayList = new ArrayList<Xpp3Dom>();
            for (n = 0; n < xpp3DomArray.length; ++n) {
                arrayList.add(xpp3DomArray[n]);
            }
            n = 0;
            ListIterator listIterator = element.getChildren().listIterator();
            while (listIterator.hasNext()) {
                Element element2 = (Element)listIterator.next();
                Iterator object2 = arrayList.iterator();
                object = null;
                while (object2.hasNext()) {
                    Xpp3Dom xpp3Dom2 = (Xpp3Dom)object2.next();
                    if (!xpp3Dom2.getName().equals(element2.getName())) continue;
                    object = xpp3Dom2;
                    break;
                }
                if (object != null) {
                    arrayList.remove(object);
                    this.replaceXpp3DOM(element2, (Xpp3Dom)object, new Counter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                element.removeContent((Content)element2);
            }
            for (Xpp3Dom xpp3Dom3 : arrayList) {
                object = this.factory.element(xpp3Dom3.getName(), element.getNamespace());
                this.insertAtPreferredLocation(element, (Element)object, counter);
                counter.increaseCount();
                this.replaceXpp3DOM((Element)object, xpp3Dom3, new Counter(counter.getDepth() + 1));
            }
        } else if (xpp3Dom.getValue() != null) {
            element.setText(xpp3Dom.getValue());
        }
    }

    protected void updateActivation(Activation activation, String string, Counter counter, Element element) {
        boolean bl = activation != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "activeByDefault", !activation.isActiveByDefault() ? null : String.valueOf(activation.isActiveByDefault()), "false");
            this.findAndReplaceSimpleElement(counter2, element2, "jdk", activation.getJdk(), null);
            this.updateActivationOS(activation.getOs(), "os", counter2, element2);
            this.updateActivationProperty(activation.getProperty(), "property", counter2, element2);
            this.updateActivationFile(activation.getFile(), "file", counter2, element2);
        }
    }

    protected void updateActivationFile(ActivationFile activationFile, String string, Counter counter, Element element) {
        boolean bl = activationFile != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "missing", activationFile.getMissing(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "exists", activationFile.getExists(), null);
        }
    }

    protected void updateActivationOS(ActivationOS activationOS, String string, Counter counter, Element element) {
        boolean bl = activationOS != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "name", activationOS.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "family", activationOS.getFamily(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "arch", activationOS.getArch(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "version", activationOS.getVersion(), null);
        }
    }

    protected void updateActivationProperty(ActivationProperty activationProperty, String string, Counter counter, Element element) {
        boolean bl = activationProperty != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "name", activationProperty.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "value", activationProperty.getValue(), null);
        }
    }

    protected Element updateElement(Counter counter, Element element, String string, boolean bl) {
        Element element2 = element.getChild(string, element.getNamespace());
        if (element2 != null && bl) {
            counter.increaseCount();
        }
        if (element2 == null && bl) {
            element2 = this.factory.element(string, element.getNamespace());
            this.insertAtPreferredLocation(element, element2, counter);
            counter.increaseCount();
        }
        if (!bl && element2 != null) {
            Text text;
            Content content;
            int n = element.indexOf((Content)element2);
            if (n > 0 && (content = element.getContent(n - 1)) instanceof Text && (text = (Text)content).getTextTrim().length() == 0) {
                element.removeContent((Content)text);
            }
            element.removeContent((Content)element2);
        }
        return element2;
    }

    protected void updateIdentifiableBase(IdentifiableBase identifiableBase, String string, Counter counter, Element element) {
        boolean bl = identifiableBase != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "id", identifiableBase.getId(), null);
        }
    }

    protected void updateMirror(Mirror mirror, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "mirrorOf", mirror.getMirrorOf(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "name", mirror.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", mirror.getUrl(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "id", mirror.getId(), null);
    }

    protected void updateProfile(Profile profile, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.updateActivation(profile.getActivation(), "activation", counter2, element2);
        this.findAndReplaceProperties(counter2, element2, "properties", profile.getProperties());
        this.iterateRepository(counter2, element2, profile.getRepositories(), "repositories", "repository");
        this.iterateRepository(counter2, element2, profile.getPluginRepositories(), "pluginRepositories", "pluginRepository");
        this.findAndReplaceSimpleElement(counter2, element2, "id", profile.getId(), null);
    }

    protected void updateProxy(Proxy proxy, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "active", !proxy.isActive() ? null : String.valueOf(proxy.isActive()), "false");
        this.findAndReplaceSimpleElement(counter2, element2, "protocol", proxy.getProtocol(), "http");
        this.findAndReplaceSimpleElement(counter2, element2, "username", proxy.getUsername(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "password", proxy.getPassword(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "port", proxy.getPort() == 8080 ? null : String.valueOf(proxy.getPort()), "8080");
        this.findAndReplaceSimpleElement(counter2, element2, "host", proxy.getHost(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "nonProxyHosts", proxy.getNonProxyHosts(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "id", proxy.getId(), null);
    }

    protected void updateRepository(Repository repository, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.updateRepositoryPolicy(repository.getReleases(), "releases", counter2, element2);
        this.updateRepositoryPolicy(repository.getSnapshots(), "snapshots", counter2, element2);
        this.findAndReplaceSimpleElement(counter2, element2, "id", repository.getId(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "name", repository.getName(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "url", repository.getUrl(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "layout", repository.getLayout(), "default");
    }

    protected void updateRepositoryBase(RepositoryBase repositoryBase, String string, Counter counter, Element element) {
        boolean bl = repositoryBase != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "id", repositoryBase.getId(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "name", repositoryBase.getName(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "url", repositoryBase.getUrl(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "layout", repositoryBase.getLayout(), "default");
        }
    }

    protected void updateRepositoryPolicy(RepositoryPolicy repositoryPolicy, String string, Counter counter, Element element) {
        boolean bl = repositoryPolicy != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
            this.findAndReplaceSimpleElement(counter2, element2, "enabled", repositoryPolicy.isEnabled() ? null : String.valueOf(repositoryPolicy.isEnabled()), "true");
            this.findAndReplaceSimpleElement(counter2, element2, "updatePolicy", repositoryPolicy.getUpdatePolicy(), null);
            this.findAndReplaceSimpleElement(counter2, element2, "checksumPolicy", repositoryPolicy.getChecksumPolicy(), null);
        }
    }

    protected void updateServer(Server server, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "username", server.getUsername(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "password", server.getPassword(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "privateKey", server.getPrivateKey(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "passphrase", server.getPassphrase(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "filePermissions", server.getFilePermissions(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "directoryPermissions", server.getDirectoryPermissions(), null);
        this.findAndReplaceXpp3DOM(counter2, element2, "configuration", (Xpp3Dom)server.getConfiguration());
        this.findAndReplaceSimpleElement(counter2, element2, "id", server.getId(), null);
    }

    protected void updateSettings(Settings settings, String string, Counter counter, Element element) {
        Element element2 = element;
        Counter counter2 = new Counter(counter.getDepth() + 1);
        this.findAndReplaceSimpleElement(counter2, element2, "localRepository", settings.getLocalRepository(), null);
        this.findAndReplaceSimpleElement(counter2, element2, "interactiveMode", settings.isInteractiveMode() ? null : String.valueOf(settings.isInteractiveMode()), "true");
        this.findAndReplaceSimpleElement(counter2, element2, "usePluginRegistry", !settings.isUsePluginRegistry() ? null : String.valueOf(settings.isUsePluginRegistry()), "false");
        this.findAndReplaceSimpleElement(counter2, element2, "offline", !settings.isOffline() ? null : String.valueOf(settings.isOffline()), "false");
        this.iterateProxy(counter2, element2, settings.getProxies(), "proxies", "proxy");
        this.iterateServer(counter2, element2, settings.getServers(), "servers", "server");
        this.iterateMirror(counter2, element2, settings.getMirrors(), "mirrors", "mirror");
        this.iterateProfile(counter2, element2, settings.getProfiles(), "profiles", "profile");
        this.findAndReplaceSimpleLists(counter2, element2, settings.getActiveProfiles(), "activeProfiles", "activeProfile");
        this.findAndReplaceSimpleLists(counter2, element2, settings.getPluginGroups(), "pluginGroups", "pluginGroup");
    }

    protected void updateTrackableBase(TrackableBase trackableBase, String string, Counter counter, Element element) {
        boolean bl = trackableBase != null;
        Element element2 = this.updateElement(counter, element, string, bl);
        if (bl) {
            Counter counter2 = new Counter(counter.getDepth() + 1);
        }
    }

    public void write(Settings settings, Document document, OutputStream outputStream) throws IOException {
        this.updateSettings(settings, "settings", new Counter(0), document.getRootElement());
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat().setIndent("    ").setLineSeparator(System.getProperty("line.separator")));
        xMLOutputter.output(document, outputStream);
    }

    public void write(Settings settings, Document document, OutputStreamWriter outputStreamWriter) throws IOException {
        Format format = Format.getRawFormat().setEncoding(outputStreamWriter.getEncoding()).setLineSeparator(System.getProperty("line.separator"));
        this.write(settings, document, outputStreamWriter, format);
    }

    public void write(Settings settings, Document document, Writer writer, Format format) throws IOException {
        this.updateSettings(settings, "settings", new Counter(0), document.getRootElement());
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(format);
        xMLOutputter.output(document, writer);
    }

    public class Counter {
        private int currentIndex = 0;
        private int level;

        public Counter(int n) {
            this.level = n;
        }

        public int getCurrentIndex() {
            return this.currentIndex;
        }

        public int getDepth() {
            return this.level;
        }

        public void increaseCount() {
            ++this.currentIndex;
        }
    }
}

