/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(JsfIndexer.class.getSimpleName());

    protected void index(Indexable indexable, Parser.Result result, Context context) {
        try {
            FileObject fileObject = result.getSnapshot().getSource().getFileObject();
            LOG.log(Level.FINE, "indexing " + fileObject.getPath());
            LinkedList<IndexDocument> linkedList = new LinkedList<IndexDocument>();
            IndexingSupport indexingSupport = IndexingSupport.getInstance((Context)context);
            Collection<JsfPageModel> collection = JsfPageModelFactory.getModels((HtmlParserResult)result);
            for (JsfPageModel jsfPageModel : collection) {
                IndexDocument indexDocument = indexingSupport.createDocument(indexable);
                jsfPageModel.storeToIndex(indexDocument);
                linkedList.add(indexDocument);
            }
            for (IndexDocument indexDocument : linkedList) {
                indexingSupport.addDocument(indexDocument);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends EmbeddingIndexerFactory {
        static final String NAME = "jsf";
        static final int VERSION = 1;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(snapshot)) {
                return new JsfIndexer();
            }
            return null;
        }

        public void filesDeleted(Iterable<? extends Indexable> iterable, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> iterable, Context context) {
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 1;
        }

        private boolean isIndexable(Snapshot snapshot) {
            WebModule webModule;
            FileObject fileObject = snapshot.getSource().getFileObject();
            String string = fileObject.getMIMEType();
            return "text/xhtml".equals(string) && (webModule = WebModule.getWebModule((FileObject)fileObject)) != null;
        }
    }
}

