/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfIndex {
    private final QuerySupport embeddingIndex;
    private final QuerySupport binaryIndex;

    public static JsfIndex create(WebModule webModule) throws IOException {
        FileObject[] fileObjectArray = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/source").getRoots();
        FileObject[] fileObjectArray2 = ClassPath.getClassPath((FileObject)webModule.getDocumentBase(), (String)"classpath/execute").getRoots();
        QuerySupport querySupport = QuerySupport.forRoots((String)"jsf", (int)1, (FileObject[])fileObjectArray);
        QuerySupport querySupport2 = QuerySupport.forRoots((String)"jsfBinary", (int)5, (FileObject[])fileObjectArray2);
        return new JsfIndex(querySupport, querySupport2);
    }

    private JsfIndex(QuerySupport querySupport, QuerySupport querySupport2) {
        this.embeddingIndex = querySupport;
        this.binaryIndex = querySupport2;
    }

    private QuerySupport getEmbeddingIndex() {
        return this.embeddingIndex;
    }

    private QuerySupport getBinaryIndex() {
        return this.binaryIndex;
    }

    public Collection<String> getAllCompositeLibraryNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getAllCompositeLibraryNames(this.getBinaryIndex()));
        arrayList.addAll(this.getAllCompositeLibraryNames(this.getEmbeddingIndex()));
        return arrayList;
    }

    private Collection<String> getAllCompositeLibraryNames(QuerySupport querySupport) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection collection = querySupport.query("library", "", QuerySupport.Kind.PREFIX, new String[]{"library"});
            for (IndexResult indexResult : collection) {
                String string = indexResult.getValue("library");
                if (string == null) continue;
                arrayList.add(string);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    public Collection<String> getCompositeLibraryComponents(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getCompositeLibraryComponents(this.getBinaryIndex(), string));
        arrayList.addAll(this.getCompositeLibraryComponents(this.getEmbeddingIndex(), string));
        return arrayList;
    }

    private Collection<String> getCompositeLibraryComponents(QuerySupport querySupport, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Collection collection = querySupport.query("library", string, QuerySupport.Kind.EXACT, new String[]{"library"});
            for (IndexResult indexResult : collection) {
                FileObject fileObject = indexResult.getFile();
                if (fileObject == null) continue;
                arrayList.add(fileObject.getName());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    public CompositeComponentModel getCompositeComponentModel(String string, String string2) {
        CompositeComponentModel compositeComponentModel = this.getCompositeComponentModel(this.getEmbeddingIndex(), string, string2);
        return compositeComponentModel != null ? compositeComponentModel : this.getCompositeComponentModel(this.getBinaryIndex(), string, string2);
    }

    private CompositeComponentModel getCompositeComponentModel(QuerySupport querySupport, String string, String string2) {
        try {
            Collection collection = querySupport.query("library", string, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation"});
            for (IndexResult indexResult : collection) {
                String string3;
                FileObject fileObject = indexResult.getFile();
                if (fileObject == null || !(string3 = fileObject.getName()).equals(string2)) continue;
                return (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(indexResult);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public Map<String, FileObject> getAllTldLibraries() {
        HashMap<String, FileObject> hashMap = new HashMap<String, FileObject>();
        try {
            Collection collection = this.getBinaryIndex().query("tagLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "namespace"});
            for (IndexResult indexResult : collection) {
                FileObject fileObject = indexResult.getFile();
                if (fileObject == null) continue;
                hashMap.put(indexResult.getValue("namespace"), fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return hashMap;
    }

    public FileObject getTldFile(String string) {
        try {
            Collection collection = this.getBinaryIndex().query("namespace", string, QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "namespace"});
            for (IndexResult indexResult : collection) {
                if (indexResult.getValue("tagLibraryDescriptor") == null) continue;
                return indexResult.getFile();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public Collection<FileObject> getAllFaceletsLibraryDescriptors() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        try {
            Collection collection = this.getBinaryIndex().query("faceletsLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor"});
            for (IndexResult indexResult : collection) {
                FileObject fileObject = indexResult.getFile();
                if (fileObject == null) continue;
                arrayList.add(fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    public FileObject getFaceletsLibaryDescriptorFile(String string) {
        try {
            Collection collection = this.getBinaryIndex().query("namespace", string, QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor", "namespace"});
            for (IndexResult indexResult : collection) {
                if (indexResult.getValue("faceletsLibraryDescriptor") == null) continue;
                return indexResult.getFile();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

