/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.completion;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JsfCompletionItem {
    private static final int JSF_DEFAULT_SORT_PRIORITY = 5;

    public static JsfTag createTag(int n, FaceletsLibrary.NamedComponent namedComponent, String string, boolean bl) {
        return new JsfTag(n, namedComponent, string, bl);
    }

    public static JsfTagAttribute createAttribute(String string, int n, FaceletsLibrary faceletsLibrary, LibraryDescriptor.Tag tag, LibraryDescriptor.Attribute attribute) {
        return new JsfTagAttribute(string, n, faceletsLibrary, tag, attribute);
    }

    private static String getLibraryHelpHeader(FaceletsLibrary faceletsLibrary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<div><b>Library:</b> ");
        stringBuffer.append(faceletsLibrary.getNamespace());
        if (faceletsLibrary.getDisplayName() != null) {
            stringBuffer.append(" (");
            stringBuffer.append(faceletsLibrary.getDisplayName());
            stringBuffer.append(")</div>");
        }
        return stringBuffer.toString();
    }

    public static class JsfTagAttribute
    extends HtmlCompletionItem.Attribute {
        private FaceletsLibrary library;
        private LibraryDescriptor.Tag tag;
        private LibraryDescriptor.Attribute attr;

        public JsfTagAttribute(String string, int n, FaceletsLibrary faceletsLibrary, LibraryDescriptor.Tag tag, LibraryDescriptor.Attribute attribute) {
            super(string, n, attribute.isRequired(), null);
            this.library = faceletsLibrary;
            this.tag = tag;
            this.attr = attribute;
        }

        public String getHelp() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(JsfCompletionItem.getLibraryHelpHeader(this.library));
            stringBuffer.append("<div><b>Tag:</b> ");
            stringBuffer.append(this.tag.getName());
            stringBuffer.append("</div>");
            stringBuffer.append("<h1>");
            stringBuffer.append(this.attr.getName());
            stringBuffer.append("</h1>");
            stringBuffer.append(this.attr.getDescription());
            return stringBuffer.toString();
        }

        public boolean hasHelp() {
            return this.attr.getDescription() != null;
        }
    }

    public static class JsfTag
    extends HtmlCompletionItem.Tag {
        private static final String BOLD_OPEN_TAG = "<b>";
        private static final String BOLD_END_TAG = "</b>";
        private FaceletsLibrary.NamedComponent component;
        private boolean autoimport;

        public JsfTag(int n, FaceletsLibrary.NamedComponent namedComponent, String string, boolean bl) {
            super(JsfTag.generateItemText(namedComponent, string), n, null, true);
            this.component = namedComponent;
            this.autoimport = bl;
        }

        private static String generateItemText(FaceletsLibrary.NamedComponent namedComponent, String string) {
            String string2 = namedComponent.getLibrary().getDefaultPrefix();
            return (string != null ? string : string2) + ":" + namedComponent.getName();
        }

        protected String getRightHtmlText() {
            return this.component.getLibrary().getDisplayName();
        }

        public void defaultAction(JTextComponent jTextComponent) {
            super.defaultAction(jTextComponent);
            if (this.autoimport) {
                this.autoimportLibrary(jTextComponent);
            }
        }

        private void autoimportLibrary(JTextComponent jTextComponent) {
            BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            FaceletsLibrary faceletsLibrary = this.component.getLibrary();
            JsfUtils.importLibrary((Document)baseDocument, faceletsLibrary, null);
        }

        protected String getLeftHtmlText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(BOLD_OPEN_TAG);
            stringBuffer.append(super.getLeftHtmlText());
            stringBuffer.append(BOLD_END_TAG);
            return stringBuffer.toString();
        }

        public int getSortPriority() {
            return 5;
        }

        public String getHelp() {
            LibraryDescriptor.Tag tag;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(JsfCompletionItem.getLibraryHelpHeader(this.component.getLibrary()));
            stringBuffer.append("<h1>");
            stringBuffer.append(this.component.getName());
            stringBuffer.append("</h1>");
            if (Boolean.getBoolean("show-facelets-libraries-locations")) {
                stringBuffer.append("<div style=\"font-size: smaller; color: gray;\">");
                stringBuffer.append("Source: ");
                stringBuffer.append(FileUtil.getFileDisplayName((FileObject)this.component.getLibrary().getLibraryDescriptor().getDefinitionFile()));
                stringBuffer.append("</div>");
            }
            if ((tag = this.component.getTag()) != null) {
                String string = tag.getDescription();
                if (string == null) {
                    stringBuffer.append(NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("MSG_NO_TLD_ITEM_DESCR"));
                } else {
                    stringBuffer.append(string);
                }
            } else {
                String string = NbBundle.getBundle(((Object)((Object)this)).getClass()).getString("MSG_NO_TLD");
                stringBuffer.append("<table border=\"1\">");
                for (String[] stringArray : this.component.getDescription()) {
                    stringBuffer.append("<tr>");
                    stringBuffer.append("<td>");
                    stringBuffer.append("<div style=\"font-weight: bold\">");
                    stringBuffer.append(stringArray[0]);
                    stringBuffer.append("</div>");
                    stringBuffer.append("</td>");
                    stringBuffer.append("<td>");
                    stringBuffer.append(stringArray[1]);
                    stringBuffer.append("</td>");
                    stringBuffer.append("</tr>");
                }
                stringBuffer.append("</table>");
                stringBuffer.append("<p style=\"color: red\">" + string + "</p>");
            }
            return stringBuffer.toString();
        }

        public boolean hasHelp() {
            return true;
        }
    }
}

