/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ant;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hudson.ant.AntBasedJobCreator;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public abstract class ProjectTypes
implements AntBasedJobCreator {
    private final String type;
    private final TargetTemplate[] templates;

    private ProjectTypes(String string, TargetTemplate[] targetTemplateArray) {
        this.type = string;
        this.templates = targetTemplateArray;
    }

    public String type() {
        return this.type;
    }

    public AntBasedJobCreator.Configuration forProject(Project project) {
        return new ConfigurationImpl(project);
    }

    private static class TargetTemplate {
        private final String antName;
        private final String bundleKey;
        private final boolean mandatory;
        private final String artifactIncludes;
        private final String artifactExcludes;
        private final String javadocDir;
        private final boolean checkForTests;
        private final String testResults;
        private final String properties;

        TargetTemplate(String string, String string2, boolean bl, String string3, String string4, String string5, boolean bl2, String string6, String string7) {
            this.antName = string;
            this.bundleKey = string2;
            assert (!bl || !bl2);
            this.mandatory = bl;
            this.artifactIncludes = string3;
            this.artifactExcludes = string4;
            this.javadocDir = string5;
            this.checkForTests = bl2;
            this.testResults = string6;
            this.properties = string7;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigurationImpl
    implements AntBasedJobCreator.Configuration {
        private final Project project;

        ConfigurationImpl(Project project) {
            this.project = project;
        }

        @Override
        public List<AntBasedJobCreator.Target> targets() {
            ArrayList<AntBasedJobCreator.Target> arrayList = new ArrayList<AntBasedJobCreator.Target>();
            for (final TargetTemplate targetTemplate : ProjectTypes.this.templates) {
                arrayList.add(new AntBasedJobCreator.Target(){
                    final boolean selected;
                    {
                        this.selected = !targetTemplate.checkForTests || this.hasTests(ConfigurationImpl.this.project);
                    }

                    public String antName() {
                        return targetTemplate.antName;
                    }

                    public String labelWithMnemonic() {
                        return NbBundle.getMessage(ProjectTypes.class, (String)targetTemplate.bundleKey);
                    }

                    public boolean selected() {
                        return this.selected;
                    }

                    public boolean enabled() {
                        return this.selected && !targetTemplate.mandatory;
                    }

                    public AntBasedJobCreator.ArchivePattern artifactArchival() {
                        if (targetTemplate.artifactIncludes != null) {
                            return new AntBasedJobCreator.ArchivePattern(){

                                public String includes() {
                                    return targetTemplate.artifactIncludes;
                                }

                                public String excludes() {
                                    return targetTemplate.artifactExcludes;
                                }
                            };
                        }
                        return null;
                    }

                    public String javadocDir() {
                        return targetTemplate.javadocDir;
                    }

                    public String testResults() {
                        return targetTemplate.testResults;
                    }

                    public String properties() {
                        return targetTemplate.properties;
                    }

                    boolean hasTests(Project project) {
                        for (SourceGroup sourceGroup : ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
                            FileObject fileObject = sourceGroup.getRootFolder();
                            if (UnitTestForSourceQuery.findSources((FileObject)fileObject).length <= 0 || !this.containsSources(fileObject)) continue;
                            return true;
                        }
                        return false;
                    }

                    boolean containsSources(FileObject fileObject) {
                        if (fileObject.isFolder()) {
                            for (FileObject fileObject2 : fileObject.getChildren()) {
                                if (!this.containsSources(fileObject2)) continue;
                                return true;
                            }
                            return false;
                        }
                        return fileObject.hasExt("java");
                    }
                });
            }
            return arrayList;
        }
    }

    public static class EAR
    extends ProjectTypes {
        public EAR() {
            super("org.netbeans.modules.j2ee.earproject", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null)});
        }
    }

    public static class CAR
    extends ProjectTypes {
        public CAR() {
            super("org.netbeans.modules.j2ee.clientproject", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }

    public static class EJB
    extends ProjectTypes {
        public EJB() {
            super("org.netbeans.modules.j2ee.ejbjarproject", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }

    public static class Web
    extends ProjectTypes {
        public Web() {
            super("org.netbeans.modules.web.project", new TargetTemplate[]{new TargetTemplate("dist", "ProjectTypes.buildDist.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }

    public static class J2SE
    extends ProjectTypes {
        public J2SE() {
            super("org.netbeans.modules.java.j2seproject", new TargetTemplate[]{new TargetTemplate("jar", "ProjectTypes.buildJar.text", true, "dist/", "dist/javadoc/", null, false, null, null), new TargetTemplate("javadoc", "ProjectTypes.buildJavadoc.text", false, null, null, "dist/javadoc", false, null, null), new TargetTemplate("test", "ProjectTypes.runTests.text", false, null, null, null, true, "build/test/results/TEST-*.xml", "ignore.failing.tests=true")});
        }
    }
}

