/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ant;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import javax.xml.xpath.XPathFactory;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.hudson.ant.AntBasedJobCreator;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.java.api.common.project.ui.customizer.ProjectSharability;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobCreator
extends JPanel
implements ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator {
    private final Project project;
    private final AntBasedJobCreator.Configuration config;
    private final ProjectSharability shar;
    private final HudsonSCM.Configuration scm;
    private final Map<AntBasedJobCreator.Target, JCheckBox> checkboxen;

    public JobCreator(Project project, AntBasedJobCreator.Configuration configuration) {
        this.project = project;
        this.config = configuration;
        this.shar = (ProjectSharability)project.getLookup().lookup(ProjectSharability.class);
        this.scm = ProjectHudsonJobCreatorFactory.Helper.prepareSCM((File)FileUtil.toFile((FileObject)project.getProjectDirectory()));
        this.checkboxen = this.initComponents();
    }

    public String jobName() {
        return ProjectUtils.getInformation((Project)this.project).getName();
    }

    public JComponent customizer() {
        return this;
    }

    public ProjectHudsonJobCreatorFactory.ConfigurationStatus status() {
        if (this.scm == null) {
            return ProjectHudsonJobCreatorFactory.Helper.noSCMError();
        }
        if (this.shar != null && !this.shar.isSharable()) {
            String string = NbBundle.getMessage(JobCreator.class, (String)"JobCreator.copy_message");
            JButton jButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(JobCreator.class, (String)"JobCreator.copy_label"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JobCreator.this.shar.makeSharable();
                }
            });
            return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withWarning((String)string).withExtraButton(jButton);
        }
        ProjectHudsonJobCreatorFactory.ConfigurationStatus configurationStatus = this.scm.problems();
        if (configurationStatus != null) {
            return configurationStatus;
        }
        return ProjectHudsonJobCreatorFactory.ConfigurationStatus.valid();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public Document configure() throws IOException {
        Map.Entry<AntBasedJobCreator.Target, JCheckBox> entry22;
        Document document = XMLUtil.createDocument((String)"project", null, null, null);
        Element element = document.getDocumentElement();
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<AntBasedJobCreator.Target, JCheckBox> entry22 : this.checkboxen.entrySet()) {
            if (!entry22.getValue().isSelected()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(entry22.getKey().antName());
        }
        Element element2 = (Element)element.appendChild(document.createElement("builders")).appendChild(document.createElement("hudson.tasks.Ant"));
        element2.appendChild(document.createElement("targets")).appendChild(document.createTextNode(stringBuilder.toString()));
        entry22 = null;
        for (Map.Entry<AntBasedJobCreator.Target, JCheckBox> object : this.checkboxen.entrySet()) {
            String string;
            if (!object.getValue().isSelected() || (string = object.getKey().properties()) == null) continue;
            if (entry22 == null) {
                entry22 = new StringBuilder();
            } else {
                ((StringBuilder)((Object)entry22)).append('\n');
            }
            ((StringBuilder)((Object)entry22)).append(string);
        }
        if (entry22 != null) {
            element2.appendChild(document.createElement("properties")).appendChild(document.createTextNode(((StringBuilder)((Object)entry22)).toString()));
        }
        Element element3 = (Element)element.appendChild(document.createElement("publishers"));
        for (Map.Entry<AntBasedJobCreator.Target, JCheckBox> entry : this.checkboxen.entrySet()) {
            String string;
            Object object;
            if (!entry.getValue().isSelected()) continue;
            AntBasedJobCreator.Target target = entry.getKey();
            AntBasedJobCreator.ArchivePattern archivePattern = target.artifactArchival();
            if (archivePattern != null) {
                object = (Element)element3.appendChild(document.createElement("hudson.tasks.ArtifactArchiver"));
                object.appendChild(document.createElement("artifacts")).appendChild(document.createTextNode(archivePattern.includes()));
                string = archivePattern.excludes();
                if (string != null) {
                    object.appendChild(document.createElement("excludes")).appendChild(document.createTextNode(string));
                }
                object.appendChild(document.createElement("latestOnly")).appendChild(document.createTextNode("true"));
            }
            if ((object = target.javadocDir()) != null) {
                element3.appendChild(document.createElement("hudson.tasks.JavadocArchiver")).appendChild(document.createElement("javadocDir")).appendChild(document.createTextNode((String)object));
            }
            if ((string = target.testResults()) == null) continue;
            element3.appendChild(document.createElement("hudson.tasks.junit.JUnitResultArchiver")).appendChild(document.createElement("testResults")).appendChild(document.createTextNode(string));
        }
        for (String string : new String[]{"actions", "buildWrappers"}) {
            element.appendChild(document.createElement(string));
        }
        this.scm.configure(document);
        ProjectHudsonJobCreatorFactory.Helper.addLogRotator((Document)document);
        return document;
    }

    private Map<AntBasedJobCreator.Target, JCheckBox> initComponents() {
        Object object;
        AntBasedJobCreator.Target target2;
        LinkedHashMap<AntBasedJobCreator.Target, JCheckBox> linkedHashMap = new LinkedHashMap<AntBasedJobCreator.Target, JCheckBox>();
        for (AntBasedJobCreator.Target target2 : this.config.targets()) {
            object = new JCheckBox();
            linkedHashMap.put(target2, (JCheckBox)object);
            ((AbstractButton)object).setSelected(target2.selected());
            ((AbstractButton)object).setEnabled(target2.enabled());
            Mnemonics.setLocalizedText((AbstractButton)object, (String)target2.labelWithMnemonic());
            ((JCheckBox)object).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JobCreator.class, (String)"JobCreator.checkbox.a11y", (Object)target2.antName()));
        }
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        target2 = groupLayout.createParallelGroup(1);
        for (JCheckBox jCheckBox : linkedHashMap.values()) {
            target2.add(jCheckBox);
        }
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)target2).addContainerGap(-1, Short.MAX_VALUE)));
        object = groupLayout.createSequentialGroup();
        boolean bl = false;
        for (JCheckBox jCheckBox : linkedHashMap.values()) {
            if (bl) {
                bl = false;
                object.addContainerGap();
            } else {
                object.addPreferredGap(0);
            }
            object.add((Component)jCheckBox);
        }
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)object.addContainerGap(-1, Short.MAX_VALUE)));
        return linkedHashMap;
    }

    public static class Factory
    implements ProjectHudsonJobCreatorFactory {
        public ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator forProject(Project project) {
            FileObject fileObject = project.getProjectDirectory().getFileObject("nbproject/project.xml");
            if (fileObject != null && fileObject.isData()) {
                try {
                    Document document = XMLUtil.parse((InputSource)new InputSource(fileObject.getURL().toString()), (boolean)false, (boolean)true, null, null);
                    String string = XPathFactory.newInstance().newXPath().evaluate("/*/*[local-name(.)='type']", document.getDocumentElement());
                    for (AntBasedJobCreator antBasedJobCreator : Lookup.getDefault().lookupAll(AntBasedJobCreator.class)) {
                        if (!antBasedJobCreator.type().equals(string)) continue;
                        return new JobCreator(project, antBasedJobCreator.forProject(project));
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(JobCreator.class.getName()).log(Level.FINE, "Could not check type of " + fileObject, exception);
                }
            }
            return null;
        }
    }
}

