/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.parser;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.xml.tax.parser.ParserLoader;
import org.netbeans.modules.xml.tax.parser.Util;
import org.netbeans.tax.io.TreeBuilder;
import org.netbeans.tax.io.TreeInputSource;
import org.netbeans.tax.io.TreeStreamBuilderErrorHandler;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TreeStreamSource
implements TreeInputSource {
    private static final String BUILDER_IMPL = "org.netbeans.tax.io.XNIBuilder";
    private InputSource inputSource;
    private Class buildClass;
    private ErrorHolder errorHolder;

    public TreeStreamSource(Class clazz, InputSource inputSource, URL uRL) {
        this.buildClass = clazz;
        this.inputSource = inputSource;
        this.errorHolder = new ErrorHolder();
    }

    public TreeBuilder getBuilder() {
        return this.getImplementation();
    }

    private TreeBuilder getImplementation() {
        ClassLoader classLoader;
        if (Boolean.getBoolean("netbeans.tax.use_private_xni_impl")) {
            classLoader = ParserLoader.getInstance();
            if (classLoader == null) {
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("Can not get loader.");
                }
                return null;
            }
        } else {
            classLoader = TreeBuilder.class.getClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(BUILDER_IMPL);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("!!! TreeStreamSource.getImplementation", classNotFoundException);
            }
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getConstructor(Class.class, InputSource.class, EntityResolver.class, TreeStreamBuilderErrorHandler.class);
            return (TreeBuilder)constructor.newInstance(this.buildClass, this.inputSource, this.getSystemEntityResolver(), this.errorHolder);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(invocationTargetException);
            }
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(noSuchMethodException);
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(instantiationException);
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug(illegalAccessException);
            }
            return null;
        }
    }

    private EntityResolver getSystemEntityResolver() {
        EntityResolver entityResolver;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeStreamSource.getSystemEntityResolver:");
        }
        UserCatalog userCatalog = UserCatalog.getDefault();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    UserCatalog.getDefault() = " + userCatalog);
        }
        EntityResolver entityResolver2 = entityResolver = userCatalog == null ? null : userCatalog.getEntityResolver();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("    EntityResolver = " + entityResolver);
        }
        if (entityResolver == null) {
            return null;
        }
        entityResolver = new EntityResolverWrapper(entityResolver);
        return entityResolver;
    }

    static class EntityResolverWrapper
    implements EntityResolver {
        private final EntityResolver res;

        public EntityResolverWrapper(EntityResolver entityResolver) {
            if (entityResolver == null) {
                throw new NullPointerException();
            }
            this.res = entityResolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputSource resolveEntity(final String string, final String string2) throws SAXException, IOException {
            this.res.resolveEntity(null, "urn:nowhere");
            ErrorManager errorManager = ErrorManager.getDefault();
            final InputSource inputSource = new InputSource("mark");
            try {
                InputSource[] inputSourceArray = new InputSource[]{inputSource};
                SAXException[] sAXExceptionArray = new SAXException[1];
                Object object = new IOException[1];
                String[] stringArray = new Runnable((IOException[])object, sAXExceptionArray, inputSourceArray){
                    private final /* synthetic */ IOException[] val$ioex;
                    private final /* synthetic */ SAXException[] val$sex;
                    private final /* synthetic */ InputSource[] val$result;
                    {
                        this.val$ioex = iOExceptionArray;
                        this.val$sex = sAXExceptionArray;
                        this.val$result = inputSourceArray;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        InputSource inputSource2 = inputSource;
                        try {
                            inputSource2 = EntityResolverWrapper.this.res.resolveEntity(string, string2);
                        }
                        catch (IOException iOException) {
                            this.val$ioex[0] = iOException;
                        }
                        catch (SAXException sAXException) {
                            this.val$sex[0] = sAXException;
                        }
                        finally {
                            EntityResolverWrapper entityResolverWrapper = EntityResolverWrapper.this;
                            synchronized (entityResolverWrapper) {
                                if (inputSource2 != inputSource) {
                                    this.val$result[0] = inputSource2;
                                }
                                EntityResolverWrapper.this.notify();
                            }
                        }
                    }
                };
                Object object2 = new Thread((Runnable)stringArray, "Timeouted EntityResolver");
                ((Thread)object2).setDaemon(true);
                ((Thread)object2).start();
                Object object3 = this;
                synchronized (object3) {
                    if (inputSourceArray[0] == inputSource) {
                        this.wait(300L);
                    }
                }
                if (inputSourceArray[0] == inputSource) {
                    StatusDisplayer.getDefault().setStatusText(Util.THIS.getString("MSG_resolving"));
                    object3 = this;
                    synchronized (object3) {
                        int n = Integer.getInteger("netbeans.xml.resolver.timeout", 5000);
                        if (inputSourceArray[0] == inputSource) {
                            this.wait(n);
                        }
                    }
                }
                if (inputSourceArray[0] != inputSource) {
                    object3 = inputSourceArray[0];
                    return object3;
                }
                try {
                    if (sAXExceptionArray[0] != null) {
                        throw sAXExceptionArray[0];
                    }
                    if (object[0] != null) {
                        throw object[0];
                    }
                    ((Thread)object2).interrupt();
                    ((Thread)object2).setPriority(1);
                    ((Thread)object2).setName("Zombie");
                    object3 = new IOException("Resolution timeout \"" + string2 + "\" (" + string + ")");
                    String string3 = Util.THIS.getString("MSG_cannot_connect");
                    Object[] objectArray = new String[]{string, string2};
                    String string4 = MessageFormat.format(string3, objectArray);
                    errorManager.annotate((Throwable)object3, string4);
                    throw object3;
                }
                catch (InterruptedException interruptedException) {
                    sAXExceptionArray = new IOException("Resolution interrupted \"" + string2 + "\" (" + string + ")");
                    object = Util.THIS.getString("MSG_interrupted");
                    stringArray = new String[]{string, string2};
                    object2 = MessageFormat.format((String)object, stringArray);
                    errorManager.annotate((Throwable)sAXExceptionArray, (String)object2);
                    throw sAXExceptionArray;
                }
            }
            finally {
                StatusDisplayer.getDefault().setStatusText("");
            }
        }

        public String toString() {
            return super.toString() + Util.THIS.getString("PROP_wrapping") + this.res.toString();
        }
    }

    static class EmptyEntityResolver
    implements EntityResolver {
        EmptyEntityResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return null;
        }
    }

    private class ErrorHolder
    implements TreeStreamBuilderErrorHandler {
        private ErrorHolder() {
        }

        public void message(int n, SAXParseException sAXParseException) {
            if (Util.THIS.isLoggable()) {
                Util.THIS.debug("Builder ex", sAXParseException);
            }
        }
    }
}

