/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.support;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceGroups {
    private static final Logger LOGGER = Logger.getLogger(SourceGroups.class.getName());

    private SourceGroups() {
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> set = SourceGroups.getTestSourceGroups(sourceGroupArray);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : sourceGroupArray) {
            if (set.contains(sourceGroup)) continue;
            arrayList.add(sourceGroup);
        }
        return arrayList.toArray(new SourceGroup[arrayList.size()]);
    }

    public static boolean isFolderWritable(SourceGroup sourceGroup, String string) {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"packageName", (Object)string);
        try {
            FileObject fileObject = SourceGroups.getFolderForPackage(sourceGroup, string, false);
            while (fileObject == null && string.lastIndexOf(46) != -1) {
                string = string.substring(0, string.lastIndexOf(46));
                fileObject = SourceGroups.getFolderForPackage(sourceGroup, string, false);
            }
            return fileObject == null ? sourceGroup.getRootFolder().canWrite() : fileObject.canWrite();
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
            return false;
        }
    }

    public static SourceGroup getFolderSourceGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        Parameters.notNull((CharSequence)"sourceGroups", (Object)sourceGroupArray);
        Parameters.notNull((CharSequence)"folder", (Object)fileObject);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroupArray[i];
        }
        return null;
    }

    public static String getPackageForFolder(SourceGroup sourceGroup, FileObject fileObject) {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"folder", (Object)fileObject);
        String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
        if (string == null) {
            throw new IllegalStateException("The given folder [ " + fileObject.getPath() + "] is not in the " + "same tree with [" + sourceGroup.getRootFolder().getPath() + "]");
        }
        return string.replace('/', '.');
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String string) throws IOException {
        return SourceGroups.getFolderForPackage(sourceGroup, string, true);
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String string, boolean bl) throws IOException {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"packageName", (Object)string);
        String string2 = string.replace('.', '/');
        FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
        if (fileObject != null) {
            return fileObject;
        }
        if (bl) {
            return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)string2);
        }
        return null;
    }

    public static SourceGroup getClassSourceGroup(Project project, String string) {
        SourceGroup[] sourceGroupArray;
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notEmpty((CharSequence)"fqClassName", (CharSequence)string);
        String string2 = string.replace('.', '/') + ".java";
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
            if (fileObject == null) continue;
            return sourceGroup;
        }
        return null;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map;
        if (sourceGroupArray.length == 0) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap<FileObject, SourceGroup>(2 * sourceGroupArray.length, 0.5f);
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                map.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return map;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map<FileObject, SourceGroup> map) {
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        List<FileObject> list = SourceGroups.getFileObjects(uRLArray);
        for (int i = 0; i < list.size(); ++i) {
            FileObject fileObject = list.get(i);
            SourceGroup sourceGroup2 = map.get(fileObject);
            if (sourceGroup2 == null) continue;
            arrayList.add(sourceGroup2);
        }
        return arrayList;
    }

    private static List<FileObject> getFileObjects(URL[] uRLArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (int i = 0; i < uRLArray.length; ++i) {
            FileObject fileObject = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObject != null) {
                arrayList.add(fileObject);
                continue;
            }
            Logger.getLogger(SourceGroup.class.getName()).log(Level.INFO, "No FileObject found for the following URL: " + uRLArray[i]);
        }
        return arrayList;
    }

    private static Set<SourceGroup> getTestSourceGroups(SourceGroup[] sourceGroupArray) {
        Map<FileObject, SourceGroup> map = SourceGroups.createFoldersToSourceGroupsMap(sourceGroupArray);
        HashSet<SourceGroup> hashSet = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashSet.addAll(SourceGroups.getTestTargets(sourceGroupArray[i], map));
        }
        return hashSet;
    }
}

