/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.ui;

import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.impl.ScanningScopeList;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.NbPreferences;

public class Settings {
    private static final String PREF_FOLDING_WIDTH = "folding_table_col_";
    private static final String PREF_REGULAR_WIDTH = "table_col_";
    private static Settings theInstance;
    private Preferences prefs = NbPreferences.forModule(Settings.class);

    private Settings() {
    }

    public static Settings getDefault() {
        if (null == theInstance) {
            theInstance = new Settings();
        }
        return theInstance;
    }

    public int getSortingColumn() {
        return this.prefs.getInt("sortingColumn", -1);
    }

    public void setSortingColumn(int n) {
        this.prefs.putInt("sortingColumn", n);
    }

    public boolean isAscendingSort() {
        return this.prefs.getBoolean("sortingAscending", true);
    }

    public void setAscendingSort(boolean bl) {
        this.prefs.putBoolean("sortingAscending", bl);
    }

    public float getPreferredColumnWidth(int n, boolean bl, float f) {
        return this.prefs.getFloat((bl ? PREF_FOLDING_WIDTH : PREF_REGULAR_WIDTH) + n, f);
    }

    public void setPreferredColumnWidth(int n, boolean bl, float f) {
        this.prefs.putFloat((bl ? PREF_FOLDING_WIDTH : PREF_REGULAR_WIDTH) + n, f);
    }

    public boolean isGroupExpanded(String string) {
        return this.prefs.getBoolean("expanded_" + string, true);
    }

    public void setGroupExpanded(String string, boolean bl) {
        this.prefs.putBoolean("expanded_" + string, bl);
    }

    public void setActiveScanningScope(TaskScanningScope taskScanningScope) {
        this.prefs.put("activeScanningScope", taskScanningScope.getClass().getName());
    }

    public TaskScanningScope getActiveScanningScope() {
        String string = this.prefs.get("activeScanningScope", null);
        if (null != string) {
            for (TaskScanningScope taskScanningScope : ScanningScopeList.getDefault().getTaskScanningScopes()) {
                if (!taskScanningScope.getClass().getName().equals(string)) continue;
                return taskScanningScope;
            }
        }
        return null;
    }

    public void setGroupTasksByCategory(boolean bl) {
        this.prefs.putBoolean("groupTasksByCategory", bl);
    }

    public boolean getGroupTasksByCategory() {
        return this.prefs.getBoolean("groupTasksByCategory", false);
    }
}

