/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.netbeans.modules.tasklist.impl.ScannerDescriptor;
import org.netbeans.modules.tasklist.ui.checklist.CheckList;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class TypesPanel
extends JPanel {
    private CheckList lstTypes;
    private List<? extends ScannerDescriptor> providers;
    private boolean[] providerState;
    private TypesFilter filter;
    private JButton btnOptions;
    private JLabel lblVisibleLimit;
    private JScrollPane scrollTypes;
    private JTextField txtVisibleLimit;

    public TypesPanel(TypesFilter typesFilter) {
        this.filter = typesFilter;
        this.init();
        if ("Metal".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    public boolean isValueValid() {
        return this.checkVisibleLimit();
    }

    private void init() {
        this.initComponents();
        this.providers = ScannerDescriptor.getDescriptors();
        this.providerState = new boolean[this.providers.size()];
        Object[] objectArray = new String[this.providers.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.providers.get(i).getDisplayName();
        }
        this.lstTypes = new CheckList(this.providerState, objectArray);
        this.lstTypes.setSelectionMode(0);
        this.lstTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TypesPanel.this.lstTypes.getSelectedIndex();
                boolean bl = false;
                if (n >= 0) {
                    ScannerDescriptor scannerDescriptor = (ScannerDescriptor)TypesPanel.this.providers.get(n);
                    bl = null != scannerDescriptor.getOptionsPath();
                }
                TypesPanel.this.btnOptions.setEnabled(bl);
            }
        });
        this.lstTypes.getModel().addListDataListener(new ListDataListener(){

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                TypesPanel.this.putClientProperty("value-valid", new Boolean(TypesPanel.this.isValueValid()));
            }
        });
        this.btnOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ScannerDescriptor scannerDescriptor;
                int n = TypesPanel.this.lstTypes.getSelectedIndex();
                if (n >= 0 && null != (scannerDescriptor = (ScannerDescriptor)TypesPanel.this.providers.get(n)).getOptionsPath()) {
                    OptionsDisplayer.getDefault().open(scannerDescriptor.getOptionsPath());
                }
            }
        });
        this.scrollTypes.setViewportView(this.lstTypes);
        this.showFilter(this.filter);
    }

    private void showFilter(TypesFilter typesFilter) {
        for (int i = 0; i < this.providerState.length; ++i) {
            ScannerDescriptor scannerDescriptor = this.providers.get(i);
            this.providerState[i] = null != typesFilter && typesFilter.isEnabled(scannerDescriptor.getType());
        }
        this.txtVisibleLimit.setText(null == typesFilter ? "" : String.valueOf(typesFilter.getTaskCountLimit()));
        this.lstTypes.setEnabled(null != typesFilter);
        this.txtVisibleLimit.setEnabled(null != typesFilter);
    }

    private void initComponents() {
        this.lblVisibleLimit = new JLabel();
        this.txtVisibleLimit = new JTextField();
        this.btnOptions = new JButton();
        this.scrollTypes = new JScrollPane();
        this.setOpaque(false);
        this.lblVisibleLimit.setLabelFor(this.txtVisibleLimit);
        Mnemonics.setLocalizedText((JLabel)this.lblVisibleLimit, (String)NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.lblVisibleLimit.text"));
        this.txtVisibleLimit.setText(NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.txtVisibleLimit.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOptions, (String)NbBundle.getMessage(TypesPanel.class, (String)"TypesPanel.btnOptions.text"));
        this.btnOptions.setEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.scrollTypes, -1, 367, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnOptions)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblVisibleLimit).addPreferredGap(0).add((Component)this.txtVisibleLimit, -2, 49, -2))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.btnOptions).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.scrollTypes, -1, 158, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblVisibleLimit).add((Component)this.txtVisibleLimit, -2, -1, -2)))).addContainerGap()));
    }

    public TypesFilter getFilter() {
        if (this.filter != null) {
            for (int i = 0; i < this.providerState.length; ++i) {
                ScannerDescriptor scannerDescriptor = this.providers.get(i);
                this.filter.setEnabled(scannerDescriptor.getType(), this.providerState[i]);
            }
            this.filter.setTaskCountLimit(this.getVisibleLimit());
        }
        return this.filter;
    }

    private int getVisibleLimit() {
        int n = null == this.filter ? 100 : this.filter.getTaskCountLimit();
        try {
            String string = this.txtVisibleLimit.getText();
            int n2 = Integer.parseInt(string);
            if (n2 > 0) {
                n = n2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private boolean checkVisibleLimit() {
        try {
            String string = this.txtVisibleLimit.getText();
            int n = Integer.parseInt(string);
            return n > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

