/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.tasklist.filter.AppliedFilterCondition;
import org.netbeans.modules.tasklist.filter.ConditionPanel;
import org.netbeans.modules.tasklist.filter.FilterSubpanel;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class KeywordsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private KeywordsFilter filter;
    private FilterSubpanel subpanel;
    final JPanel conditionsPanel = new JPanel();
    final JScrollPane conditionsScrollPane = new JScrollPane();
    final JButton fewerButton = new JButton();
    final JRadioButton matchAllRadio = new JRadioButton();
    final JRadioButton matchAnyRadio = new JRadioButton();
    final ButtonGroup matchGroup = new ButtonGroup();
    final JButton moreButton = new JButton();
    final ButtonGroup subtaskGroup = new ButtonGroup();

    public KeywordsPanel(KeywordsFilter keywordsFilter) {
        this.filter = keywordsFilter;
        this.initComponents();
        this.initA11y();
        if ("Metal".equals(UIManager.getLookAndFeel().getID())) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.conditionsPanel, "North");
        this.conditionsScrollPane.setViewportView(jPanel);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.charWidth('n') * 80;
        int n2 = fontMetrics.getHeight() * 10;
        this.conditionsScrollPane.setPreferredSize(new Dimension(n, n2));
        Color color = (Color)UIManager.get("Table.background");
        this.conditionsPanel.setBackground(color);
        jPanel.setBackground(color);
        this.moreButton.addActionListener(this);
        this.fewerButton.addActionListener(this);
        this.matchAllRadio.addActionListener(this);
        this.matchAnyRadio.addActionListener(this);
        this.showFilter(keywordsFilter);
        this.updateSensitivity();
    }

    public void initSubpanel(FilterSubpanel filterSubpanel) {
        assert (this.subpanel == null);
        this.subpanel = filterSubpanel;
    }

    private void showFilter(KeywordsFilter keywordsFilter) {
        if (keywordsFilter != null) {
            if (keywordsFilter.matchAll()) {
                this.matchAllRadio.setSelected(true);
            } else {
                this.matchAnyRadio.setSelected(true);
            }
            this.conditionsPanel.removeAll();
            List list = keywordsFilter.getConditions();
            if (list.size() > 0) {
                for (AppliedFilterCondition appliedFilterCondition : list) {
                    this.addCondition(false, appliedFilterCondition);
                }
            } else {
                this.addCondition(false, null);
            }
        } else {
            this.setEnabled(false);
            this.matchAnyRadio.setEnabled(false);
            this.matchAllRadio.setEnabled(false);
            this.conditionsPanel.setEnabled(false);
            this.moreButton.setEnabled(false);
            this.fewerButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.matchGroup.add(this.matchAllRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.matchAllRadio, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"MatchAll"));
        this.matchAllRadio.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_MatchAll"));
        this.matchAllRadio.setOpaque(false);
        this.matchGroup.add(this.matchAnyRadio);
        this.matchAnyRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.matchAnyRadio, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"MatchAny"));
        this.matchAnyRadio.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_MatchAny"));
        this.matchAnyRadio.setOpaque(false);
        this.conditionsScrollPane.setVerticalScrollBarPolicy(22);
        this.conditionsScrollPane.setAlignmentX(0.0f);
        this.conditionsScrollPane.setAlignmentY(0.0f);
        this.conditionsScrollPane.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.conditionsPanel.setLayout(new GridBagLayout());
        this.conditionsScrollPane.setViewportView(this.conditionsPanel);
        Mnemonics.setLocalizedText((AbstractButton)this.fewerButton, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"Fewer"));
        this.fewerButton.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_Fewer"));
        Mnemonics.setLocalizedText((AbstractButton)this.moreButton, (String)NbBundle.getMessage(KeywordsPanel.class, (String)"More"));
        this.moreButton.setToolTipText(NbBundle.getMessage(KeywordsPanel.class, (String)"HINT_More"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.moreButton).addPreferredGap(0).add((Component)this.fewerButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.matchAllRadio, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.matchAnyRadio, -1, -1, Short.MAX_VALUE).add(278, 278, 278)).add(2, (Component)this.conditionsScrollPane, -1, 584, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.matchAllRadio).add((Component)this.matchAnyRadio)).addPreferredGap(0).add((Component)this.conditionsScrollPane, -1, 321, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.fewerButton).add((Component)this.moreButton)).addContainerGap()));
        this.conditionsScrollPane.getAccessibleContext().setAccessibleName(null);
        this.conditionsScrollPane.getAccessibleContext().setAccessibleDescription(null);
    }

    private void initA11y() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeywordsPanel.class, (String)"ACSD_Filter"));
        this.conditionsPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(KeywordsPanel.class, (String)"ACSN_Conditions"));
        this.conditionsPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(KeywordsPanel.class, (String)"ACSD_Conditions"));
    }

    private ConditionPanel addCondition(boolean bl, AppliedFilterCondition appliedFilterCondition) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        ConditionPanel conditionPanel = new ConditionPanel(this.filter, appliedFilterCondition);
        conditionPanel.addPropertyChangeListener("value-valid", this);
        conditionPanel.setBackground((Color)UIManager.get("Table.background"));
        this.conditionsPanel.add((Component)conditionPanel, gridBagConstraints);
        if (bl) {
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.putClientProperty("value-valid", this.isValueValid());
        return conditionPanel;
    }

    public final boolean isValueValid() {
        Component[] componentArray = this.conditionsPanel.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ConditionPanel conditionPanel = (ConditionPanel)componentArray[i];
            if (conditionPanel == null || conditionPanel.isValueValid()) continue;
            return false;
        }
        return true;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.putClientProperty("value-valid", this.isValueValid());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.moreButton) {
            ConditionPanel conditionPanel = this.addCondition(true, null);
            JScrollBar jScrollBar = this.conditionsScrollPane.getVerticalScrollBar();
            jScrollBar.setValue(jScrollBar.getMaximum());
            conditionPanel.focusPropertyCombo();
        } else if (object == this.fewerButton) {
            this.conditionsPanel.remove(this.conditionsPanel.getComponentCount() - 1);
            this.invalidate();
            this.getParent().validate();
            this.repaint();
        }
        this.updateSensitivity();
        this.putClientProperty("value-valid", this.isValueValid());
    }

    private void updateSensitivity() {
        int n = this.conditionsPanel.getComponentCount();
        this.fewerButton.setEnabled(n > 0);
    }

    public KeywordsFilter getFilter() {
        if (this.filter != null) {
            Component[] componentArray = this.conditionsPanel.getComponents();
            ArrayList<AppliedFilterCondition> arrayList = new ArrayList<AppliedFilterCondition>(componentArray.length);
            for (int i = 0; i < componentArray.length; ++i) {
                AppliedFilterCondition appliedFilterCondition = ((ConditionPanel)componentArray[i]).getCondition();
                if (appliedFilterCondition == null) continue;
                arrayList.add(appliedFilterCondition);
            }
            this.filter.setConditions(arrayList);
            this.filter.setMatchAll(this.matchAllRadio.isSelected());
            if (this.subpanel != null) {
                this.subpanel.updateFilter(this.filter);
            }
        }
        return this.filter;
    }
}

