/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.util;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;

public class ContextUtil {
    private ContextUtil() {
    }

    public static String getContextName(CsmScopeElement csmScopeElement) {
        CsmScope csmScope = csmScopeElement.getScope();
        if (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            CsmClass csmClass = (CsmClass)csmScope;
            CsmNamespace csmNamespace = ContextUtil.getClassNamespace(csmClass);
            return ((Object)csmNamespace.getQualifiedName()).toString();
        }
        if (CsmKindUtilities.isNamespace((Object)csmScope)) {
            return ((Object)((CsmNamespace)csmScope).getQualifiedName()).toString();
        }
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            return ((Object)((CsmFile)csmScope).getName()).toString();
        }
        return "";
    }

    public static CsmNamespace getClassNamespace(CsmClass csmClass) {
        CsmScope csmScope = csmClass.getScope();
        while (csmScope != null && CsmKindUtilities.isClass((CsmObject)csmScope)) {
            CsmClass csmClass2 = (CsmClass)csmScope;
            csmScope = csmClass2.getScope();
        }
        return CsmKindUtilities.isNamespace((Object)csmScope) ? (CsmNamespace)csmScope : null;
    }

    public static String getClassFullName(CsmClass csmClass) {
        StringBuilder stringBuilder = new StringBuilder(csmClass.getName());
        CsmScope csmScope = csmClass.getScope();
        while (csmScope != null && CsmKindUtilities.isClass((CsmObject)csmScope)) {
            CsmClass csmClass2 = (CsmClass)csmScope;
            stringBuilder.insert(0, "::");
            stringBuilder.insert(0, csmClass2.getName());
            csmScope = csmClass2.getScope();
        }
        return stringBuilder.toString();
    }
}

