/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class RepositorySourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        File file;
        File file2;
        File file3;
        URL uRL2 = uRL;
        if (!"jar".equals(uRL.getProtocol())) {
            return null;
        }
        uRL2 = FileUtil.getArchiveFile((URL)uRL);
        FileObject fileObject = URLMapper.findFileObject((URL)uRL2);
        if (fileObject != null && (file3 = FileUtil.toFile((FileObject)fileObject)) != null && (file2 = file3.getParentFile()) != null && (file = file2.getParentFile()) != null) {
            String string = file.getName();
            String string2 = file2.getName();
            File file4 = new File(file2, string + "-" + string2 + "-sources.jar");
            if (file4.exists()) {
                return new SrcResult(file4);
            }
        }
        return null;
    }

    private class SrcResult
    implements SourceForBinaryQuery.Result {
        private static final String ATTR_PATH = "lastRootCheckPath";
        private static final String ATTR_STAMP = "lastRootCheckStamp";
        private File file;
        private final List<ChangeListener> listeners;

        public SrcResult(File file) {
            this.file = file;
            this.listeners = new ArrayList<ChangeListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(changeListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            List<ChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(changeListener);
            }
        }

        public FileObject[] getRoots() {
            FileObject fileObject;
            FileObject fileObject2;
            if (this.file.exists() && (fileObject2 = FileUtil.getArchiveRoot((FileObject)(fileObject = FileUtil.toFileObject((File)this.file)))) != null) {
                Date date = (Date)fileObject.getAttribute(ATTR_STAMP);
                String string = (String)fileObject.getAttribute(ATTR_PATH);
                if (date == null || fileObject.lastModified().after(date)) {
                    string = this.checkPath(fileObject2, fileObject);
                }
                FileObject[] fileObjectArray = new FileObject[1];
                if (string != null) {
                    fileObjectArray[0] = fileObject2.getFileObject(string);
                }
                if (fileObjectArray[0] == null) {
                    fileObjectArray[0] = fileObject2;
                }
                return fileObjectArray;
            }
            return new FileObject[0];
        }

        private String checkPath(FileObject fileObject, FileObject fileObject2) {
            String string = null;
            FileObject fileObject3 = JavadocAndSourceRootDetection.findSourceRoot((FileObject)fileObject);
            try {
                if (fileObject3 != null && !fileObject3.equals(fileObject)) {
                    string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject3);
                    fileObject2.setAttribute(ATTR_PATH, (Object)string);
                }
                fileObject2.setAttribute(ATTR_STAMP, (Object)new Date());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return string;
        }
    }
}

