/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.output;

import java.awt.Color;
import java.util.regex.Pattern;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.util.NbBundle;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class GlobalOutputProcessor
implements OutputProcessor {
    private static final String SECTION_PROJECT = "project-execute";
    private final Pattern DOWNLOAD = Pattern.compile("^(\\d+)/(\\d*)[MKb\\?]$");
    private final Pattern LOW_MVN = Pattern.compile("(.*)Error resolving version for (.*): Plugin requires Maven version (.*)");

    public String[] getRegisteredOutputSequences() {
        return new String[]{SECTION_PROJECT};
    }

    public void processLine(String string, OutputVisitor outputVisitor) {
        if (this.DOWNLOAD.matcher(string).matches()) {
            outputVisitor.skipLine();
            return;
        }
        if ("BUILD SUCCESSFUL".equals(string)) {
            outputVisitor.setColor(Color.GREEN.darker().darker());
            return;
        }
        if (this.LOW_MVN.matcher(string).matches()) {
            outputVisitor.setLine(string + NbBundle.getMessage(GlobalOutputProcessor.class, (String)"TXT_ChangeSettings"));
            outputVisitor.setColor(Color.RED);
            outputVisitor.setOutputListener(new OutputListener(){

                public void outputLineSelected(OutputEvent outputEvent) {
                }

                public void outputLineAction(OutputEvent outputEvent) {
                    OptionsDisplayer.getDefault().open("Advanced/Maven");
                }

                public void outputLineCleared(OutputEvent outputEvent) {
                }
            });
            return;
        }
    }

    public void sequenceStart(String string, OutputVisitor outputVisitor) {
        if (!string.startsWith(SECTION_PROJECT)) {
            outputVisitor.setLine("[" + string.substring("mojo-execute#".length()) + "]");
            outputVisitor.setColor(Color.GRAY);
        }
    }

    public void sequenceEnd(String string, OutputVisitor outputVisitor) {
    }

    public void sequenceFail(String string, OutputVisitor outputVisitor) {
    }
}

