/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SourcesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        NbMavenProjectImpl nbMavenProjectImpl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
        return new NList(nbMavenProjectImpl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NList
    extends AbstractMavenNodeList<SourceGroup>
    implements ChangeListener {
        private NbMavenProjectImpl project;

        private NList(NbMavenProjectImpl nbMavenProjectImpl) {
            this.project = nbMavenProjectImpl;
        }

        public List<SourceGroup> keys() {
            SourceGroup[] sourceGroupArray;
            ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
            Sources sources = ProjectUtils.getSources((Project)this.project);
            for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
                arrayList.add(sourceGroup);
            }
            return arrayList;
        }

        public Node node(SourceGroup sourceGroup) {
            Project project = FileOwnerQuery.getOwner((FileObject)sourceGroup.getRootFolder());
            if (project != this.project) {
                if (project == null) {
                    Logger.getLogger(SourcesNodeFactory.class.getName()).log(Level.INFO, "Cannot find a project owner for folder " + sourceGroup.getRootFolder());
                    return null;
                }
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
                String string = projectInformation != null ? projectInformation.getDisplayName() : FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
                abstractNode.setDisplayName(NbBundle.getMessage(SourcesNodeFactory.class, (String)"ERR_WrongSG", (Object)sourceGroup.getDisplayName(), (Object)string));
                return abstractNode;
            }
            return PackageView.createPackageView((SourceGroup)sourceGroup);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.fireChange();
            }
        }

        @Override
        public void addNotify() {
            Sources sources = ProjectUtils.getSources((Project)this.project);
            sources.addChangeListener((ChangeListener)this);
        }

        @Override
        public void removeNotify() {
            Sources sources = ProjectUtils.getSources((Project)this.project);
            sources.removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    NList.this.fireChange();
                }
            });
        }
    }
}

