/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.ActionProviderImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class SiteDocsNode
extends FilterNode {
    private NbMavenProjectImpl project;
    private boolean isTopLevelNode = false;

    SiteDocsNode(NbMavenProjectImpl nbMavenProjectImpl, Node node) {
        this(nbMavenProjectImpl, node, true);
    }

    private SiteDocsNode(NbMavenProjectImpl nbMavenProjectImpl, Node node, boolean bl) {
        super(node, (Children)(node.getChildren() == FilterNode.Children.LEAF ? FilterNode.Children.LEAF : new SiteFilterChildren(nbMavenProjectImpl, node)));
        this.isTopLevelNode = bl;
        this.project = nbMavenProjectImpl;
    }

    public String getDisplayName() {
        if (this.isTopLevelNode) {
            String string = NbBundle.getMessage(SiteDocsNode.class, (String)"LBL_Site_Pages");
            DataObject dataObject = (DataObject)this.getOriginal().getLookup().lookup(DataObject.class);
            FileObject fileObject = dataObject.getPrimaryFile();
            try {
                string = fileObject.getFileSystem().getStatus().annotateName(string, Collections.singleton(fileObject));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
            return string;
        }
        return this.getOriginal().getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (!this.isTopLevelNode) {
            return this.getOriginal().getHtmlDisplayName();
        }
        try {
            DataObject dataObject = (DataObject)this.getOriginal().getLookup().lookup(DataObject.class);
            FileObject fileObject = dataObject.getPrimaryFile();
            FileSystem.Status status = fileObject.getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                String string;
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string2 = NbBundle.getMessage(SiteDocsNode.class, (String)"LBL_Site_Pages");
                if (!string2.equals(string = htmlStatus.annotateNameHtml(string2, Collections.singleton(fileObject)))) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean bl) {
        if (this.isTopLevelNode) {
            ActionProviderImpl actionProviderImpl = (ActionProviderImpl)this.project.getLookup().lookup(ActionProviderImpl.class);
            Action[] actionArray = new Action[4];
            actionArray[0] = CommonProjectActions.newFileAction();
            actionArray[1] = null;
            NetbeansActionMapping netbeansActionMapping = new NetbeansActionMapping();
            netbeansActionMapping.addGoal("site");
            actionArray[2] = actionProviderImpl.createCustomMavenAction(NbBundle.getMessage(SiteDocsNode.class, (String)"BTN_Generate_Site"), netbeansActionMapping);
            netbeansActionMapping = new NetbeansActionMapping();
            netbeansActionMapping.addGoal("site:deploy");
            actionArray[3] = actionProviderImpl.createCustomMavenAction(NbBundle.getMessage(SiteDocsNode.class, (String)"BTN_Deploy_Site"), netbeansActionMapping, false);
            return actionArray;
        }
        return super.getActions(bl);
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        if (this.isTopLevelNode) {
            image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/projectsite-badge.png"), (int)8, (int)8);
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        if (this.isTopLevelNode) {
            image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/projectsite-badge.png"), (int)8, (int)8);
        }
        return image;
    }

    static class SiteFilterChildren
    extends FilterNode.Children {
        private NbMavenProjectImpl project;

        SiteFilterChildren(NbMavenProjectImpl nbMavenProjectImpl, Node node) {
            super(node);
            this.project = nbMavenProjectImpl;
        }

        protected Node[] createNodes(Node node) {
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject != null) {
                if (!VisibilityQuery.getDefault().isVisible(dataObject.getPrimaryFile())) {
                    return new Node[0];
                }
                SiteDocsNode siteDocsNode = new SiteDocsNode(this.project, node, false);
                return new Node[]{siteDocsNode};
            }
            Node node2 = node;
            return new Node[]{node2.cloneNode()};
        }
    }
}

