/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.modules.maven.LogicalViewProviderImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.maven.nodes.DependenciesNode;
import org.netbeans.modules.maven.nodes.OthersRootChildren;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

class OthersRootNode
extends AnnotatedAbstractNode {
    private FileObject file;
    private static final String SHOW_AS_PACKAGES = "show.as.packages";
    private static final String PREF_RESOURCES_UI = "org/netbeans/modules/maven/resources/ui";

    OthersRootNode(NbMavenProjectImpl nbMavenProjectImpl, boolean bl, FileObject fileObject) {
        super((Children)new OthersRootChildren(nbMavenProjectImpl, bl), Lookups.fixed((Object[])new Object[]{fileObject, DataFolder.findFolder((FileObject)fileObject), new ChildDelegateFind()}));
        this.setName(bl ? "OtherTestRoots" : "OtherRoots");
        this.setDisplayName(bl ? NbBundle.getMessage(OthersRootNode.class, (String)"LBL_Other_Test_Sources") : NbBundle.getMessage(OthersRootNode.class, (String)"LBL_Other_Sources"));
        this.file = fileObject;
    }

    public Action[] getActions(boolean bl) {
        List<Action> list = Arrays.asList(super.getActions(bl));
        ArrayList<Action> arrayList = new ArrayList<Action>(list.size() + 5);
        arrayList.addAll(list);
        arrayList.add(new ShowAsPackagesAction());
        Action[] actionArray = new Action[arrayList.size()];
        actionArray = arrayList.toArray(actionArray);
        return actionArray;
    }

    private Image getIcon(boolean bl) {
        Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/others-badge.png", (boolean)true);
        return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(bl), (Image)image, (int)8, (int)8);
    }

    protected Image getIconImpl(int n) {
        return this.getIcon(false);
    }

    protected Image getOpenedIconImpl(int n) {
        return this.getIcon(true);
    }

    public String getDisplayName() {
        String string = super.getDisplayName();
        try {
            string = this.file.getFileSystem().getStatus().annotateName(string, Collections.singleton(this.file));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return string;
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status status = this.file.getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string = htmlStatus.annotateNameHtml(super.getDisplayName(), Collections.singleton(this.file));
                if (!super.getDisplayName().equals(string)) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
        }
        return super.getHtmlDisplayName();
    }

    static boolean showAsPackages() {
        Preferences preferences = NbPreferences.root().node(PREF_RESOURCES_UI);
        boolean bl = preferences.getBoolean(SHOW_AS_PACKAGES, true);
        return bl;
    }

    static class ChildDelegateFind
    implements LogicalViewProviderImpl.FindDelegate {
        ChildDelegateFind() {
        }

        public Node[] getDelegates(Node node) {
            return node.getChildren().getNodes(true);
        }
    }

    private class ShowAsPackagesAction
    extends AbstractAction
    implements Presenter.Popup {
        public ShowAsPackagesAction() {
            String string = NbBundle.getMessage(DependenciesNode.class, (String)"LBL_ShowAsPackages");
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = OthersRootNode.showAsPackages();
            Preferences preferences = NbPreferences.root().node(OthersRootNode.PREF_RESOURCES_UI);
            preferences.putBoolean(OthersRootNode.SHOW_AS_PACKAGES, !bl);
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                Exceptions.printStackTrace((Throwable)backingStoreException);
            }
            ((OthersRootChildren)OthersRootNode.this.getChildren()).doRefresh();
        }

        public JMenuItem getPopupPresenter() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(OthersRootNode.showAsPackages());
            return jCheckBoxMenuItem;
        }
    }
}

