/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.maven.newproject.MavenWizardIterator;
import org.netbeans.modules.maven.newproject.UseOpenWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExistingWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;

    private ExistingWizardIterator() {
    }

    public static ExistingWizardIterator createIterator() {
        return new ExistingWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new UseOpenWizardPanel()};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(MavenWizardIterator.class, (String)"LBL_UseOpenStep")};
    }

    public Set instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set instantiate(ProgressHandle progressHandle) throws IOException {
        Set set;
        try {
            progressHandle.start(2);
            progressHandle.progress(1);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    ExistingWizardIterator.this.tryOpenProject();
                }
            });
            set = Collections.EMPTY_SET;
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            progressHandle.finish();
            throw throwable;
        }
        progressHandle.finish();
        return set;
    }

    private void tryOpenProject() {
        final Action action = ExistingWizardIterator.findAction("Actions/Project/org-netbeans-modules-project-ui-OpenProject.instance");
        if (action != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    action.actionPerformed(null);
                }
            });
        }
    }

    public static Action findAction(String string) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                Object object;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null && (object = instanceCookie.instanceCreate()) instanceof Action) {
                    Action action = (Action)object;
                    return action;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(ExistingWizardIterator.class.getName()).log(Level.WARNING, exception.getMessage(), exception);
                return null;
            }
        }
        return null;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(ExistingWizardIterator.class, (String)"MSG_One_of_Many"), new Integer(this.index + 1), new Integer(this.panels.length));
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void nextPanel() {
    }

    public void previousPanel() {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }
}

