/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.archetype.metadata.ArchetypeDescriptor;
import org.apache.maven.archetype.metadata.RequiredProperty;
import org.apache.maven.archetype.metadata.io.xpp3.ArchetypeDescriptorXpp3Reader;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.newproject.BasicEEWizardIterator;
import org.netbeans.modules.maven.newproject.MavenWizardIterator;
import org.netbeans.modules.maven.newproject.ProjectInfo;
import org.netbeans.modules.maven.options.MavenCommandSettings;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchetypeWizardUtils {
    private static final String USER_DIR_PROP = "user.dir";
    public static Archetype[] WEB_APP_ARCHS;
    public static Archetype[] EJB_ARCHS;
    public static Archetype[] EAR_ARCHS;
    public static final Archetype EA_ARCH;
    public static final String[] EE_LEVELS;
    private static final String loggerName = "org.netbeans.ui.metrics.maven";
    private static final String loggerKey = "USG_PROJECT_CREATE_MAVEN";

    private ArchetypeWizardUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void runArchetype(File file, ProjectInfo projectInfo, Archetype archetype, Map<String, String> map) throws IOException {
        String string3;
        block8: {
            Properties properties = new Properties();
            properties.setProperty("artifactId", projectInfo.artifactId);
            properties.setProperty("version", projectInfo.version);
            properties.setProperty("groupId", projectInfo.groupId);
            String string2 = projectInfo.packageName;
            if (string2 != null && string2.trim().length() > 0) {
                properties.setProperty("package", string2);
            }
            properties.setProperty("archetypeArtifactId", archetype.getArtifactId());
            properties.setProperty("archetypeGroupId", archetype.getGroupId());
            properties.setProperty("archetypeVersion", archetype.getVersion());
            properties.setProperty("basedir", file.getAbsolutePath());
            if (map != null) {
                for (String string3 : map.keySet()) {
                    properties.setProperty(string3, map.get(string3));
                }
            }
            BeanRunConfig beanRunConfig = new BeanRunConfig();
            beanRunConfig.setActivatedProfiles(Collections.<String>emptyList());
            beanRunConfig.setExecutionDirectory(file);
            beanRunConfig.setExecutionName(NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"RUN_Project_Creation"));
            beanRunConfig.setGoals(Collections.singletonList(MavenCommandSettings.getDefault().getCommand("createArchetypeNG")));
            if (archetype.getRepository() != null) {
                properties.setProperty("archetype.repository", archetype.getRepository());
                properties.setProperty("archetypeRepository", archetype.getRepository());
            }
            beanRunConfig.setInteractive(false);
            properties.setProperty("archetype.interactive", "false");
            beanRunConfig.setProperties(properties);
            if (archetype.getVersion().contains("SNAPSHOT")) {
                beanRunConfig.setUpdateSnapshots(true);
            }
            beanRunConfig.setTaskDisplayName(NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"RUN_Maven"));
            string3 = System.getProperty(USER_DIR_PROP);
            System.setProperty(USER_DIR_PROP, file.getAbsolutePath());
            try {
                ExecutorTask executorTask = RunUtils.executeMaven(beanRunConfig);
                executorTask.result();
                Object var10_9 = null;
                if (string3 != null) break block8;
                System.getProperties().remove(USER_DIR_PROP);
                return;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (string3 == null) {
                    System.getProperties().remove(USER_DIR_PROP);
                    throw throwable;
                }
                System.setProperty(USER_DIR_PROP, string3);
                throw throwable;
            }
        }
        System.setProperty(USER_DIR_PROP, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> getAdditionalProperties(Artifact artifact) {
        InputStream inputStream;
        InputStreamReader inputStreamReader;
        ArchetypeDescriptorXpp3Reader archetypeDescriptorXpp3Reader;
        ArchetypeDescriptor archetypeDescriptor;
        List list;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = artifact.getFile();
        JarFile jarFile = null;
        jarFile = new JarFile(file);
        JarEntry jarEntry = jarFile.getJarEntry("META-INF/maven/archetype-metadata.xml");
        if (jarEntry != null && (list = (archetypeDescriptor = (archetypeDescriptorXpp3Reader = new ArchetypeDescriptorXpp3Reader()).read(inputStreamReader = new InputStreamReader(inputStream = jarFile.getInputStream(jarEntry)))).getRequiredProperties()) != null && list.size() > 0) {
            for (RequiredProperty requiredProperty : list) {
                hashMap.put(requiredProperty.getKey(), requiredProperty.getDefaultValue());
            }
        }
        Object var13_14 = null;
        if (jarFile == null) return hashMap;
        try {
            jarFile.close();
            return hashMap;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return hashMap;
        {
            catch (IOException iOException) {
                Logger.getLogger(ArchetypeWizardUtils.class.getName()).log(Level.INFO, iOException.getMessage(), iOException);
                Object var13_15 = null;
                if (jarFile == null) return hashMap;
                try {
                    jarFile.close();
                    return hashMap;
                }
                catch (IOException iOException2) {
                    Exceptions.printStackTrace((Throwable)iOException2);
                }
                return hashMap;
            }
            catch (XmlPullParserException xmlPullParserException) {
                Logger.getLogger(ArchetypeWizardUtils.class.getName()).log(Level.INFO, xmlPullParserException.getMessage(), xmlPullParserException);
                Object var13_16 = null;
                if (jarFile == null) return hashMap;
                try {
                    jarFile.close();
                    return hashMap;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (jarFile == null) throw throwable;
            try {
                jarFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<FileObject> instantiate(ProgressHandle progressHandle, WizardDescriptor wizardDescriptor) throws IOException {
        Map map;
        ProjectInfo projectInfo;
        block5: {
            Set<FileObject> set;
            projectInfo = new ProjectInfo();
            projectInfo.groupId = (String)wizardDescriptor.getProperty("groupId");
            projectInfo.artifactId = (String)wizardDescriptor.getProperty("artifactId");
            projectInfo.version = (String)wizardDescriptor.getProperty("version");
            projectInfo.packageName = (String)wizardDescriptor.getProperty("package");
            Archetype archetype = (Archetype)wizardDescriptor.getProperty("archetype");
            ArchetypeWizardUtils.logUsage(archetype.getGroupId(), archetype.getArtifactId(), archetype.getVersion());
            map = (Map)wizardDescriptor.getProperty("additionalProps");
            try {
                ProjectInfo projectInfo2 = (ProjectInfo)wizardDescriptor.getProperty("ear_versionInfo");
                if (projectInfo2 == null) break block5;
                ProjectInfo projectInfo3 = (ProjectInfo)wizardDescriptor.getProperty("web_versionInfo");
                ProjectInfo projectInfo4 = (ProjectInfo)wizardDescriptor.getProperty("ejb_versionInfo");
                progressHandle.start(8 + (projectInfo3 != null ? 3 : 0) + (projectInfo4 != null ? 3 : 0));
                File file = ArchetypeWizardUtils.createFromArchetype(progressHandle, (File)wizardDescriptor.getProperty("projdir"), projectInfo, (Archetype)wizardDescriptor.getProperty("archetype"), map, 0);
                ArchetypeWizardUtils.createFromArchetype(progressHandle, (File)wizardDescriptor.getProperty("ear_projdir"), projectInfo2, (Archetype)wizardDescriptor.getProperty("ear_archetype"), null, 4);
                int n = 6;
                if (projectInfo3 != null) {
                    ArchetypeWizardUtils.createFromArchetype(progressHandle, (File)wizardDescriptor.getProperty("web_projdir"), projectInfo3, (Archetype)wizardDescriptor.getProperty("web_archetype"), null, n);
                    n += 3;
                }
                if (projectInfo4 != null) {
                    ArchetypeWizardUtils.createFromArchetype(progressHandle, (File)wizardDescriptor.getProperty("ejb_projdir"), projectInfo4, (Archetype)wizardDescriptor.getProperty("ejb_archetype"), null, n);
                    n += 3;
                }
                ArchetypeWizardUtils.addEARDeps((File)wizardDescriptor.getProperty("ear_projdir"), projectInfo4, projectInfo3, n);
                ArchetypeWizardUtils.updateProjectName(file, NbBundle.getMessage(ArchetypeWizardUtils.class, (String)"TXT_EAProjectName", (Object)projectInfo.artifactId));
                set = ArchetypeWizardUtils.openProjects(progressHandle, file, n);
                Object var12_13 = null;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                progressHandle.finish();
                throw throwable;
            }
            progressHandle.finish();
            return set;
        }
        progressHandle.start(4);
        File file = ArchetypeWizardUtils.createFromArchetype(progressHandle, (File)wizardDescriptor.getProperty("projdir"), projectInfo, (Archetype)wizardDescriptor.getProperty("archetype"), map, 0);
        Set<FileObject> set = ArchetypeWizardUtils.openProjects(progressHandle, file, 3);
        Object var12_14 = null;
        progressHandle.finish();
        return set;
    }

    private static void logUsage(String string, String string2, String string3) {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        logRecord.setParameters(new Object[]{string + ":" + string2 + ":" + string3});
        Logger.getLogger(loggerName).log(logRecord);
    }

    private static File createFromArchetype(ProgressHandle progressHandle, File file, ProjectInfo projectInfo, Archetype archetype, Map<String, String> map, int n) throws IOException {
        progressHandle.progress(++n);
        File file2 = FileUtil.normalizeFile((File)file);
        File file3 = file2.getParentFile();
        if (file3 != null && file3.exists()) {
            ProjectChooser.setProjectsFolder((File)file3);
        }
        file2.getParentFile().mkdirs();
        progressHandle.progress(NbBundle.getMessage(MavenWizardIterator.class, (String)"PRG_Processing_Archetype"), ++n);
        ArchetypeWizardUtils.runArchetype(file2.getParentFile(), projectInfo, archetype, map);
        progressHandle.progress(++n);
        return file2;
    }

    private static Set<FileObject> openProjects(ProgressHandle progressHandle, File file, int n) throws IOException {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            linkedHashSet.add(fileObject);
            ArchetypeWizardUtils.processProjectFolder(fileObject);
            Enumeration enumeration = fileObject.getFolders(true);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                if (!ProjectManager.getDefault().isProject(fileObject2)) continue;
                linkedHashSet.add(fileObject2);
                ArchetypeWizardUtils.processProjectFolder(fileObject2);
            }
        }
        progressHandle.progress(++n);
        return linkedHashSet;
    }

    private static void processProjectFolder(FileObject fileObject) {
        try {
            Project project = ProjectManager.getDefault().findProject(fileObject);
            if (project == null) {
                return;
            }
            final NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (nbMavenProject != null) {
                if (!"pom".equals(nbMavenProject.getPackagingType())) {
                    URI uRI = FileUtilities.convertStringToUri(nbMavenProject.getMavenProject().getBuild().getSourceDirectory());
                    URI uRI2 = FileUtilities.convertStringToUri(nbMavenProject.getMavenProject().getBuild().getTestSourceDirectory());
                    File file = new File(uRI);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    if (!(file = new File(uRI2)).exists()) {
                        file.mkdirs();
                    }
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        nbMavenProject.downloadDependencyAndJavadocSource();
                    }
                });
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
    }

    private static void addEARDeps(File file, ProjectInfo projectInfo, ProjectInfo projectInfo2, int n) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            return;
        }
        if (projectInfo != null) {
            ModelUtils.addDependency(fileObject.getFileObject("pom.xml"), projectInfo.groupId, projectInfo.artifactId, projectInfo.version, "ejb", null, null, true);
        }
        if (projectInfo2 != null) {
            ModelUtils.addDependency(fileObject.getFileObject("pom.xml"), projectInfo2.groupId, projectInfo2.artifactId, projectInfo2.version, "war", null, null, false);
        }
        ++n;
    }

    private static void updateProjectName(File file, final String string) {
        FileObject fileObject = FileUtil.toFileObject((File)new File(file, "pom.xml"));
        if (fileObject != null) {
            ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                public void performOperation(POMModel pOMModel) {
                    pOMModel.getProject().setName(string);
                }
            };
            Utilities.performPOMModelOperations((FileObject)fileObject, Collections.singletonList(modelOperation));
        }
    }

    static {
        EE_LEVELS = new String[]{NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_JEE6"), NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_JEE5"), NbBundle.getMessage(BasicEEWizardIterator.class, (String)"LBL_J2EE14")};
        WEB_APP_ARCHS = new Archetype[3];
        Archetype archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.2");
        archetype.setArtifactId("webapp-javaee6");
        ArchetypeWizardUtils.WEB_APP_ARCHS[0] = archetype;
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.1");
        archetype.setArtifactId("webapp-jee5");
        ArchetypeWizardUtils.WEB_APP_ARCHS[1] = archetype;
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.1");
        archetype.setArtifactId("webapp-j2ee14");
        ArchetypeWizardUtils.WEB_APP_ARCHS[2] = archetype;
        EJB_ARCHS = new Archetype[3];
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.2");
        archetype.setArtifactId("ejb-javaee6");
        ArchetypeWizardUtils.EJB_ARCHS[0] = archetype;
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.1");
        archetype.setArtifactId("ejb-jee5");
        ArchetypeWizardUtils.EJB_ARCHS[1] = archetype;
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.1");
        archetype.setArtifactId("ejb-j2ee14");
        ArchetypeWizardUtils.EJB_ARCHS[2] = archetype;
        EAR_ARCHS = new Archetype[3];
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0");
        archetype.setArtifactId("ear-javaee6");
        ArchetypeWizardUtils.EAR_ARCHS[0] = archetype;
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.1");
        archetype.setArtifactId("ear-jee5");
        ArchetypeWizardUtils.EAR_ARCHS[1] = archetype;
        archetype = new Archetype();
        archetype.setGroupId("org.codehaus.mojo.archetypes");
        archetype.setVersion("1.0.1");
        archetype.setArtifactId("ear-j2ee14");
        ArchetypeWizardUtils.EAR_ARCHS[2] = archetype;
        EA_ARCH = new Archetype();
        EA_ARCH.setGroupId("org.codehaus.mojo.archetypes");
        EA_ARCH.setVersion("1.0.1");
        EA_ARCH.setArtifactId("pom-root");
    }
}

