/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.output.ContextOutputProcessorFactory;
import org.netbeans.modules.maven.api.output.NotifyFinishOutputProcessor;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputProcessorFactory;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorLines;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutputHandler {
    protected static final String PRJ_EXECUTE = "project-execute";
    protected HashMap<String, Set<OutputProcessor>> processors = new HashMap();
    protected Set<OutputProcessor> currentProcessors = new HashSet<OutputProcessor>();
    protected Set<NotifyFinishOutputProcessor> toFinishProcessors;
    protected OutputVisitor visitor = new OutputVisitor();
    private RequestProcessor.Task sleepTask;
    private static final int SLEEP_DELAY = 5000;

    protected AbstractOutputHandler() {
        this.toFinishProcessors = new HashSet<NotifyFinishOutputProcessor>();
    }

    protected AbstractOutputHandler(final ProgressHandle progressHandle) {
        this();
        this.sleepTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                progressHandle.suspend("");
            }
        });
    }

    protected AbstractOutputHandler(final AggregateProgressHandle aggregateProgressHandle) {
        this();
        this.sleepTask = RequestProcessor.getDefault().create(new Runnable(){

            public void run() {
                aggregateProgressHandle.suspend("");
            }
        });
    }

    protected abstract InputOutput getIO();

    protected void checkSleepiness() {
        RequestProcessor.Task task = this.sleepTask;
        if (task != null) {
            task.schedule(5000);
        }
    }

    protected final void quitSleepiness() {
        RequestProcessor.Task task = this.sleepTask;
        if (task != null) {
            task.cancel();
            this.sleepTask = null;
        }
    }

    abstract MavenEmbedderLogger getLogger();

    protected final String getEventId(String string, String string2) {
        if (PRJ_EXECUTE.equals(string)) {
            return string;
        }
        return string + "#" + string2;
    }

    protected final void initProcessorList(Project project, RunConfig runConfig) {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(OutputProcessorFactory.class));
        for (OutputProcessorFactory outputProcessorFactory : result.allInstances()) {
            Set<OutputProcessor> set = outputProcessorFactory.createProcessorsSet(project);
            if (outputProcessorFactory instanceof ContextOutputProcessorFactory) {
                set = new HashSet<OutputProcessor>(set);
                set.addAll(((ContextOutputProcessorFactory)outputProcessorFactory).createProcessorsSet(project, runConfig));
            }
            for (OutputProcessor outputProcessor : set) {
                String[] stringArray = outputProcessor.getRegisteredOutputSequences();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    Set<OutputProcessor> set2 = this.processors.get(string);
                    if (set2 == null) {
                        set2 = new HashSet<OutputProcessor>();
                        this.processors.put(string, set2);
                    }
                    set2.add(outputProcessor);
                }
            }
        }
    }

    protected final void processStart(String string, OutputWriter outputWriter) {
        this.checkSleepiness();
        Set<OutputProcessor> set = this.processors.get(string);
        if (set != null) {
            this.currentProcessors.addAll(set);
        }
        this.visitor.resetVisitor();
        for (OutputProcessor outputProcessor : this.currentProcessors) {
            outputProcessor.sequenceStart(string, this.visitor);
        }
        if (this.visitor.getLine() != null) {
            if (this.visitor.getOutputListener() != null) {
                try {
                    outputWriter.println(this.visitor.getLine(), this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (this.visitor.getColor() != null && IOColorLines.isSupported((InputOutput)this.getIO())) {
                try {
                    IOColorLines.println((InputOutput)this.getIO(), (CharSequence)this.visitor.getLine(), (Color)this.visitor.getColor());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                outputWriter.println(this.visitor.getLine());
            }
        }
    }

    protected final void processEnd(String string, OutputWriter outputWriter) {
        Set<OutputProcessor> set;
        this.checkSleepiness();
        this.visitor.resetVisitor();
        for (OutputProcessor object2 : this.currentProcessors) {
            object2.sequenceEnd(string, this.visitor);
            if (!(object2 instanceof NotifyFinishOutputProcessor)) continue;
            this.toFinishProcessors.add((NotifyFinishOutputProcessor)object2);
        }
        if (this.visitor.getLine() != null) {
            if (this.visitor.getOutputListener() != null) {
                try {
                    outputWriter.println(this.visitor.getLine(), this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                outputWriter.println(this.visitor.getLine());
            }
        }
        if ((set = this.processors.get(string)) != null) {
            this.currentProcessors.removeAll(set);
        }
    }

    protected final void processFail(String string, OutputWriter outputWriter) {
        Set<OutputProcessor> set;
        this.checkSleepiness();
        this.visitor.resetVisitor();
        for (OutputProcessor object2 : this.currentProcessors) {
            if (object2 instanceof NotifyFinishOutputProcessor) {
                this.toFinishProcessors.add((NotifyFinishOutputProcessor)object2);
            }
            object2.sequenceFail(string, this.visitor);
        }
        if (this.visitor.getLine() != null) {
            if (this.visitor.getOutputListener() != null) {
                try {
                    outputWriter.println(this.visitor.getLine(), this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                outputWriter.println(this.visitor.getLine());
            }
        }
        if ((set = this.processors.get(string)) != null) {
            HashSet<OutputProcessor> hashSet = new HashSet<OutputProcessor>();
            hashSet.addAll(set);
            hashSet.retainAll(this.currentProcessors);
            HashSet<OutputProcessor> hashSet2 = new HashSet<OutputProcessor>();
            hashSet2.addAll(set);
            hashSet2.removeAll(hashSet);
            this.currentProcessors.removeAll(hashSet2);
        }
    }

    protected final void buildFinished() {
        this.quitSleepiness();
        for (NotifyFinishOutputProcessor notifyFinishOutputProcessor : this.toFinishProcessors) {
            notifyFinishOutputProcessor.buildFinished();
        }
    }

    protected final void processMultiLine(String string, OutputWriter outputWriter, String string2) {
        if (string == null) {
            return;
        }
        for (String string3 : AbstractOutputHandler.splitMultiLine(string)) {
            this.processLine(string3, outputWriter, string2);
        }
    }

    protected final void processLine(String string, OutputWriter outputWriter, String string2) {
        this.checkSleepiness();
        this.visitor.resetVisitor();
        for (OutputProcessor object : this.currentProcessors) {
            object.processLine(string, this.visitor);
        }
        if (!this.visitor.isLineSkipped()) {
            String string3;
            String string4 = string3 = this.visitor.getLine() == null ? string : this.visitor.getLine();
            if (this.visitor.getOutputListener() != null) {
                try {
                    outputWriter.println((string2.length() == 0 ? "" : "[" + string2 + "]") + string3, this.visitor.getOutputListener(), this.visitor.isImportant());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else if (this.visitor.getColor() != null && IOColorLines.isSupported((InputOutput)this.getIO())) {
                try {
                    IOColorLines.println((InputOutput)this.getIO(), (CharSequence)string3, (Color)this.visitor.getColor());
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                outputWriter.println((string2.length() == 0 ? "" : "[" + string2 + "]") + string3);
            }
        }
    }

    public static List<String> splitMultiLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = string.split("\\r|\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }
}

