/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import hidden.org.codehaus.plexus.util.DirectoryScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.maven.model.Resource;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.cos.CosChecker;
import org.netbeans.modules.maven.spi.cos.AdditionalDestination;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyResourcesOnSave
extends FileChangeAdapter {
    private static CopyResourcesOnSave instance = new CopyResourcesOnSave();
    private boolean isAdded = false;

    private CopyResourcesOnSave() {
    }

    public static CopyResourcesOnSave getInstance() {
        return instance;
    }

    public void checkOpenProjects() {
        boolean bl = false;
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            if (project.getLookup().lookup(NbMavenProject.class) == null) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (!this.isAdded) {
                FileUtil.addFileChangeListener((FileChangeListener)this);
                this.isAdded = true;
            }
        } else if (this.isAdded) {
            FileUtil.removeFileChangeListener((FileChangeListener)this);
            this.isAdded = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySrcToDest(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (fileObject2 != null && !fileObject.isFolder()) {
            FileLock fileLock;
            OutputStream outputStream;
            block8: {
                InputStream inputStream = null;
                outputStream = null;
                fileLock = null;
                try {
                    inputStream = fileObject.getInputStream();
                    fileLock = fileObject2.lock();
                    outputStream = fileObject2.getOutputStream(fileLock);
                    FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                    Object var7_6 = null;
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    private Project getOwningMavenProject(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (nbMavenProject == null) {
            return null;
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(project) || RunUtils.hasApplicationCompileOnSaveEnabled(project)) {
            return project;
        }
        return null;
    }

    public void fileChanged(final FileEvent fileEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyResourcesOnSave.this.fileChanged(fileEvent);
                }
            });
            return;
        }
        Project project = this.getOwningMavenProject(fileEvent.getFile());
        if (project == null) {
            return;
        }
        try {
            this.handleCopyFileToDestDir(fileEvent.getFile(), project);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileDataCreated(final FileEvent fileEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyResourcesOnSave.this.fileDataCreated(fileEvent);
                }
            });
            return;
        }
        Project project = this.getOwningMavenProject(fileEvent.getFile());
        if (project == null) {
            return;
        }
        try {
            this.handleCopyFileToDestDir(fileEvent.getFile(), project);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void fileRenamed(final FileRenameEvent fileRenameEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyResourcesOnSave.this.fileRenamed(fileRenameEvent);
                }
            });
            return;
        }
        try {
            FileObject fileObject = fileRenameEvent.getFile();
            Project project = this.getOwningMavenProject(fileObject);
            if (project == null) {
                return;
            }
            Tuple tuple = this.findAppropriateResourceRoots(fileObject, project);
            if (tuple != null) {
                this.handleCopyFileToDestDir(tuple, fileObject, project);
                FileObject fileObject2 = fileObject.getParent();
                String string = FileUtil.isParentOf((FileObject)tuple.root, (FileObject)fileObject2) ? FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fileObject.getParent()) + "/" + fileRenameEvent.getName() + "." + fileRenameEvent.getExt() : fileRenameEvent.getName() + "." + fileRenameEvent.getExt();
                this.handleDeleteFileInDestDir(fileObject, string, tuple, project);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public void fileDeleted(final FileEvent fileEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    CopyResourcesOnSave.this.fileDeleted(fileEvent);
                }
            });
            return;
        }
        Project project = this.getOwningMavenProject(fileEvent.getFile());
        if (project == null) {
            return;
        }
        try {
            this.handleDeleteFileInDestDir(fileEvent.getFile(), null, project);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void handleDeleteFileInDestDir(FileObject fileObject, String string, Project project) throws IOException {
        Tuple tuple = this.findAppropriateResourceRoots(fileObject, project);
        this.handleDeleteFileInDestDir(fileObject, string, tuple, project);
    }

    private void handleDeleteFileInDestDir(FileObject fileObject, String string, Tuple tuple, Project project) throws IOException {
        if (tuple != null) {
            AdditionalDestination additionalDestination;
            string = string != null ? string : FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fileObject);
            FileObject fileObject2 = tuple.destinationRoot.getFileObject(string = this.addTargetPath(string, tuple.resource));
            if (fileObject2 != null) {
                fileObject2.delete();
            }
            if ((additionalDestination = (AdditionalDestination)project.getLookup().lookup(AdditionalDestination.class)) != null) {
                additionalDestination.delete(fileObject, string);
            }
        }
    }

    private void handleCopyFileToDestDir(FileObject fileObject, Project project) throws IOException {
        Tuple tuple = this.findAppropriateResourceRoots(fileObject, project);
        this.handleCopyFileToDestDir(tuple, fileObject, project);
    }

    private void handleCopyFileToDestDir(Tuple tuple, FileObject fileObject, Project project) throws IOException {
        if (tuple != null && !tuple.resource.isFiltering()) {
            String string = FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fileObject);
            string = this.addTargetPath(string, tuple.resource);
            FileObject fileObject2 = this.ensureDestinationFileExists(tuple.destinationRoot, string, fileObject.isFolder());
            this.copySrcToDest(fileObject, fileObject2);
            AdditionalDestination additionalDestination = (AdditionalDestination)project.getLookup().lookup(AdditionalDestination.class);
            if (additionalDestination != null) {
                additionalDestination.copy(fileObject, string);
            }
        }
    }

    private String addTargetPath(String string, Resource resource) {
        String string2 = resource.getTargetPath();
        if (string2 != null) {
            string2 = (string2 = string2.replace("\\", "/")).endsWith("/") ? string2 : string2 + "/";
            string = string2 + string;
        }
        return string;
    }

    private Tuple findAppropriateResourceRoots(FileObject fileObject, Project project) {
        Tuple tuple;
        Tuple tuple2;
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        assert (nbMavenProject != null);
        boolean bl = RunUtils.hasTestCompileOnSaveEnabled(project);
        if (bl && (tuple2 = this.findResource(nbMavenProject.getMavenProject().getTestResources(), project, nbMavenProject, fileObject, true)) != null) {
            return tuple2;
        }
        boolean bl2 = RunUtils.hasApplicationCompileOnSaveEnabled(project);
        if ((bl || bl2) && (tuple = this.findResource(nbMavenProject.getMavenProject().getResources(), project, nbMavenProject, fileObject, false)) != null) {
            return tuple;
        }
        return null;
    }

    private Tuple findResource(List<Resource> list, Project project, NbMavenProject nbMavenProject, FileObject fileObject, boolean bl) {
        Object object;
        if (list == null) {
            return null;
        }
        MavenProject mavenProject = nbMavenProject.getMavenProject();
        FileObject fileObject2 = null;
        if (mavenProject.getBuild() != null) {
            object = new File(bl ? mavenProject.getBuild().getTestOutputDirectory() : mavenProject.getBuild().getOutputDirectory());
            File file = new File((File)(object = FileUtil.normalizeFile((File)object)), ".netbeans_automatic_build");
            if (!file.exists()) {
                return null;
            }
        } else {
            return null;
        }
        fileObject2 = FileUtil.toFileObject((File)object);
        block0: for (Resource resource : list) {
            URI uRI = FileUtilities.getDirURI(project.getProjectDirectory(), resource.getDirectory());
            FileObject fileObject3 = FileUtil.toFileObject((File)new File(uRI));
            if (fileObject3 == null || !FileUtil.isParentOf((FileObject)fileObject3, (FileObject)fileObject)) continue;
            String string = FileUtil.getRelativePath((FileObject)fileObject3, (FileObject)fileObject);
            List<String> list2 = resource.getIncludes();
            if (list2.size() == 0) {
                list2 = Arrays.asList(CosChecker.DEFAULT_INCLUDES);
            }
            boolean bl2 = false;
            for (String string2 : list2) {
                if (!DirectoryScanner.match((String)string2, (String)string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) break;
            ArrayList arrayList = new ArrayList(resource.getExcludes());
            arrayList.addAll(Arrays.asList(DirectoryScanner.DEFAULTEXCLUDES));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!DirectoryScanner.match((String)string3, (String)string)) continue;
                continue block0;
            }
            return new Tuple(resource, fileObject3, fileObject2);
        }
        return null;
    }

    private FileObject ensureDestinationFileExists(FileObject fileObject, String string, boolean bl) throws IOException {
        if (bl) {
            return FileUtil.createFolder((FileObject)fileObject, (String)string);
        }
        return FileUtil.createData((FileObject)fileObject, (String)string);
    }

    private class Tuple {
        Resource resource;
        FileObject root;
        FileObject destinationRoot;

        private Tuple(Resource resource, FileObject fileObject, FileObject fileObject2) {
            this.resource = resource;
            this.root = fileObject;
            this.destinationRoot = fileObject2;
        }
    }
}

