/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndorsedClassPathImpl
implements ClassPathImplementation {
    private List<? extends PathResourceImplementation> resourcesCache;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final NbMavenProjectImpl project;
    private BootClassPathImpl bcp;
    private String[] current;
    private final Set<URL> djpbcp = new HashSet<URL>();

    EndorsedClassPathImpl(NbMavenProjectImpl nbMavenProjectImpl) {
        this.project = nbMavenProjectImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends PathResourceImplementation> getResources() {
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            if (this.resourcesCache == null) {
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                String[] stringArray = this.getBootClasspath();
                if (stringArray != null) {
                    for (URL uRL : this.stripDefaultJavaPlatform(stringArray)) {
                        arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    }
                }
                this.current = stringArray;
                this.resourcesCache = Collections.unmodifiableList(arrayList);
            }
            return this.resourcesCache;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private String[] getBootClasspath() {
        String string;
        Properties properties;
        String string2 = PluginPropertyUtils.getPluginProperty(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArgument", "compile");
        if (string2 != null) {
            // empty if block
        }
        if ((properties = PluginPropertyUtils.getPluginPropertyParameter(this.project, "org.apache.maven.plugins", "maven-compiler-plugin", "compilerArguments", "compile")) != null && (string = properties.getProperty("bootclasspath")) != null) {
            return StringUtils.split((String)string, (String)File.pathSeparator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resetCache() {
        Object[] objectArray = this.getBootClasspath();
        boolean bl = false;
        assert (this.bcp != null);
        Object object = this.bcp.LOCK;
        synchronized (object) {
            if (!Arrays.equals(objectArray, this.current)) {
                this.resourcesCache = null;
                bl = true;
            }
        }
        if (bl) {
            this.support.firePropertyChange("resources", null, null);
        }
        return bl;
    }

    void setBCP(BootClassPathImpl bootClassPathImpl) {
        this.bcp = bootClassPathImpl;
    }

    private List<URL> stripDefaultJavaPlatform(String[] stringArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Set<URL> set = this.getDefJavaPlatBCP();
        for (String string : stringArray) {
            File file = FileUtilities.convertStringToFile(string);
            URL uRL = FileUtil.urlForArchiveOrDir((File)file);
            if (uRL == null || set.contains(uRL)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<URL> getDefJavaPlatBCP() {
        Set<URL> set = this.djpbcp;
        synchronized (set) {
            if (this.djpbcp.size() == 0) {
                JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
                JavaPlatform javaPlatform = javaPlatformManager.getDefaultPlatform();
                ClassPath classPath = javaPlatform.getBootstrapLibraries();
                for (ClassPath.Entry entry : classPath.entries()) {
                    this.djpbcp.add(entry.getURL());
                }
            }
            return Collections.unmodifiableSet(this.djpbcp);
        }
    }
}

