/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public final class DelayedDocumentChangeListener
implements DocumentListener {
    private Document doc;
    private Timer changeTimer;
    private ChangeEvent chEvt;

    public static DocumentListener create(Document document, ChangeListener changeListener, int n) {
        return new DelayedDocumentChangeListener(document, changeListener, n);
    }

    private DelayedDocumentChangeListener(Document document, final ChangeListener changeListener, int n) {
        this.doc = document;
        this.doc.addDocumentListener(this);
        this.chEvt = new ChangeEvent(document);
        this.changeTimer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                changeListener.stateChanged(DelayedDocumentChangeListener.this.chEvt);
            }
        });
        this.changeTimer.setRepeats(false);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.maybeChange(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.maybeChange(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.maybeChange(documentEvent);
    }

    private void maybeChange(DocumentEvent documentEvent) {
        this.changeTimer.restart();
    }
}

