/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.storage;

import org.netbeans.modules.dlight.api.storage.DataRow;

public final class DataUtil {
    private DataUtil() {
    }

    public static int toInt(Object object) {
        return DataUtil.toInt(object, 0);
    }

    public static int toInt(Object object, int n) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static long toLong(Object object) {
        return DataUtil.toLong(object, 0L);
    }

    public static long toLong(Object object, long l) {
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return l;
    }

    public static float toFloat(Object object) {
        return DataUtil.toFloat(object, 0.0f);
    }

    public static float toFloat(Object object, float f) {
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        if (object instanceof String) {
            try {
                return Float.parseFloat(((String)object).replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    public static double toDouble(Object object) {
        return DataUtil.toDouble(object, 0.0);
    }

    public static double toDouble(Object object, double d) {
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            try {
                return Double.parseDouble(((String)object).replace(',', '.'));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public static long getTimestamp(DataRow dataRow) {
        Object object = dataRow.getData("timestamp");
        return DataUtil.toLong(object, -1L);
    }
}

