/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.api.EncapsulateFieldsRefactoring;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.Utilities;
import org.netbeans.modules.cnd.refactoring.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.DeclarationGenerator;
import org.netbeans.modules.cnd.refactoring.support.GeneratorUtils;
import org.netbeans.modules.cnd.refactoring.support.MemberInfo;
import org.netbeans.modules.cnd.refactoring.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EncapsulateFieldPanel
extends JPanel
implements CustomRefactoringPanel {
    private boolean EXPERIMENTAL = CsmRefactoringUtils.REFACTORING_EXTRA;
    private DefaultTableModel model;
    private final CsmObject selectedObject;
    private CsmClass csmClassContainer;
    private ChangeListener parent;
    private String classname;
    private boolean isUpperCase;
    private boolean hasOutOfClassMemberDefinitions = false;
    private static boolean ALWAYS_USE_ACCESSORS = false;
    private static int FIELD_ACCESS_INDEX = 2;
    private static int METHOD_ACCESS_INDEX = 2;
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class<?>[] columnTypes = new Class[]{CsmField.class, Boolean.class, AccessorInfo.class, Boolean.class, AccessorInfo.class};
    private boolean initialized = false;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectGetters;
    private JButton jButtonSelectNone;
    private JButton jButtonSelectSetters;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JComboBox jComboInsertPoint;
    private JComboBox jComboJavadoc;
    private JComboBox jComboSort;
    private JCheckBox jInlineMethods;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblInsertPoint;
    private JLabel jLblJavadoc;
    private JLabel jLblSort;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(CsmObject csmObject, CsmContext csmContext, ChangeListener changeListener) {
        String string = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        this.selectedObject = csmObject == null ? Utilities.extractEnclosingClass(csmContext) : csmObject;
        this.parent = changeListener;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(string);
        this.jCheckAccess.setSelected(ALWAYS_USE_ACCESSORS);
        this.jCheckAccess.setEnabled(false);
        this.jComboAccess.setSelectedIndex(METHOD_ACCESS_INDEX);
        this.jComboAccess.setEnabled(false);
        this.jComboField.setSelectedIndex(FIELD_ACCESS_INDEX);
        this.jComboField.setEnabled(false);
        this.jTableFields.setDefaultRenderer(CsmField.class, new EncapsulateCsmFieldTableCellRenderer());
        this.jTableFields.setDefaultRenderer(AccessorInfo.class, new AccessorInfoRenderer());
        this.jTableFields.setDefaultEditor(AccessorInfo.class, new AccessorInfoTableEditor());
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
        EncapsulateFieldPanel.initEnumCombo(this.jComboSort, SortBy.DEFAULT);
        this.jComboSort.setEnabled(false);
        EncapsulateFieldPanel.initEnumCombo(this.jComboJavadoc, Documentation.NONE);
        this.jComboJavadoc.setEnabled(false);
    }

    public Component getComponent() {
        return this;
    }

    public final void initialize() {
        if (this.initialized) {
            return;
        }
        CsmObject csmObject = CsmRefactoringUtils.getReferencedElement(this.selectedObject);
        int n = 0;
        for (CsmField csmField : this.initFields(csmObject)) {
            boolean bl = csmField.equals(csmObject);
            boolean bl2 = bl && !EncapsulateFieldPanel.isConstant(csmField);
            String string = GeneratorUtils.computeGetterName(csmField, this.isUpperCase);
            String string2 = GeneratorUtils.computeSetterName(csmField, this.isUpperCase);
            this.model.addRow(new Object[]{MemberInfo.create(csmField), bl ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createGetter(csmField, string), bl2 ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createSetter(csmField, string2)});
            if (!bl) continue;
            n = this.model.getRowCount() - 1;
        }
        this.packRows(this.jTableFields);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.changeSelection(n, 0, false, false);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){
            boolean isUpdating = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (this.isUpdating) {
                    return;
                }
                int n = tableModelEvent.getColumn();
                int n2 = tableModelEvent.getFirstRow();
                if (n == 1 || n == 3) {
                    AccessorInfo accessorInfo;
                    Boolean bl = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                    if (bl.booleanValue() && (accessorInfo = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(n2, n + 1)) != null) {
                        accessorInfo.reset();
                    }
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.fireTableCellUpdated(n2, n + 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                AccessorInfo accessorInfo = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(n2, n);
                if (!(this.isUpdating || accessorInfo != null && accessorInfo.name != null && accessorInfo.name.length() != 0)) {
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, n2, n - 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initInsertPoints();
        this.initialized = true;
    }

    private void setColumnWidth(int n) {
        TableColumn tableColumn = this.jTableFields.getColumnModel().getColumn(n);
        JCheckBox jCheckBox = new JCheckBox();
        int n2 = (int)jCheckBox.getPreferredSize().getWidth();
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setResizable(false);
    }

    private int getMinimumRowHeight(JTable jTable, int n) {
        int n2 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n3 = component.getMinimumSize().height;
            n2 = Math.max(n2, n3);
        }
        return n2;
    }

    private void packRows(JTable jTable) {
        int n = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n2 = this.getMinimumRowHeight(jTable, i);
            if (n2 <= n) continue;
            n = n2;
        }
        jTable.setRowHeight(n);
        jTable.getTableHeader().setPreferredSize(new Dimension(jTable.getTableHeader().getPreferredSize().width, n));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jButtonSelectGetters = new JButton();
        this.jButtonSelectSetters = new JButton();
        this.jLblInsertPoint = new JLabel();
        this.jComboInsertPoint = new JComboBox();
        this.jLblSort = new JLabel();
        this.jComboSort = new JComboBox();
        this.jLblJavadoc = new JLabel();
        this.jComboJavadoc = new JComboBox();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jInlineMethods = new JCheckBox();
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldList"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectAll, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.text"));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectAllActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectNone, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.text"));
        this.jButtonSelectNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectNoneActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectGetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.text"));
        this.jButtonSelectGetters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectGettersActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectSetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.text"));
        this.jButtonSelectSetters.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EncapsulateFieldPanel.this.jButtonSelectSettersActionPerformed(actionEvent);
            }
        });
        this.jLblInsertPoint.setLabelFor(this.jComboInsertPoint);
        Mnemonics.setLocalizedText((JLabel)this.jLblInsertPoint, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblInsertPoint.text"));
        this.jLblSort.setLabelFor(this.jComboSort);
        Mnemonics.setLocalizedText((JLabel)this.jLblSort, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblSort.text"));
        this.jLblJavadoc.setLabelFor(this.jComboJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLblJavadoc, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblJavadoc.text"));
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldVis"));
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessVis"));
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessorsEven"));
        this.jTableFields.setModel(this.model);
        this.jTableFields.setCellSelectionEnabled(true);
        this.jTableFields.setSelectionMode(0);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_jTableFields"));
        Mnemonics.setLocalizedText((AbstractButton)this.jInlineMethods, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jInlineMethods.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jCheckAccess).add((Component)this.jInlineMethods).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLblAccessVis).add((Component)this.jLblFieldVis).add((Component)this.jLblInsertPoint).add((Component)this.jLblSort).add((Component)this.jLblJavadoc)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jComboInsertPoint, -2, -1, -2).add((Component)this.jComboSort, -2, -1, -2).add((Component)this.jComboJavadoc, -2, -1, -2).add((Component)this.jComboField, -2, -1, -2).add((Component)this.jComboAccess, -2, -1, -2)).add(125, 125, 125)).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollField, -1, 575, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jButtonSelectAll).add((Component)this.jButtonSelectNone).add((Component)this.jButtonSelectGetters).add((Component)this.jButtonSelectSetters)).add(12, 12, 12)).add((Component)this.jLblTitle)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.jButtonSelectAll, this.jButtonSelectGetters, this.jButtonSelectNone, this.jButtonSelectSetters}, 1);
        groupLayout.linkSize(new Component[]{this.jComboAccess, this.jComboField, this.jComboInsertPoint, this.jComboJavadoc, this.jComboSort}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLblTitle).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jButtonSelectAll).addPreferredGap(0).add((Component)this.jButtonSelectNone).addPreferredGap(0).add((Component)this.jButtonSelectGetters).addPreferredGap(0).add((Component)this.jButtonSelectSetters)).add((Component)this.jScrollField, 0, 0, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblInsertPoint).add((Component)this.jComboInsertPoint, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblSort).add((Component)this.jComboSort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblJavadoc).add((Component)this.jComboJavadoc, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblFieldVis).add((Component)this.jComboField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLblAccessVis).add((Component)this.jComboAccess, -2, -1, -2)).addPreferredGap(0).add((Component)this.jInlineMethods).addPreferredGap(0).add((Component)this.jCheckAccess).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.jComboAccess, this.jComboField, this.jComboInsertPoint, this.jComboJavadoc, this.jComboSort}, 2);
        groupLayout.linkSize(new Component[]{this.jButtonSelectAll, this.jButtonSelectGetters, this.jButtonSelectNone, this.jButtonSelectSetters}, 2);
        this.jButtonSelectAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.acsd"));
        this.jButtonSelectNone.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.acsd"));
        this.jButtonSelectGetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.acsd"));
        this.jButtonSelectSetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.acsd"));
        this.jComboInsertPoint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboInsertPoint.acsd"));
        this.jComboSort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboSort.acsd"));
        this.jComboJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboJavadoc.acsd"));
        this.jComboField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_fieldModifiers"));
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_methodAcc"));
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_useAccessors"));
        this.jInlineMethods.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_inlineMethods"));
    }

    private void jButtonSelectAllActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(true, 1, 3);
    }

    private void jButtonSelectNoneActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(false, 1, 3);
    }

    private void jButtonSelectGettersActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(true, 1);
    }

    private void jButtonSelectSettersActionPerformed(ActionEvent actionEvent) {
        this.makeSelection(true, 3);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(EncapsulateFieldPanel.class, (String)string);
    }

    private static <E extends Enum<E>> void initEnumCombo(JComboBox jComboBox, E e) {
        Vector vector = new Vector(EnumSet.allOf(e.getClass()));
        Collections.sort(vector, (Comparator)((Object)e));
        jComboBox.setModel(new DefaultComboBoxModel(vector));
        jComboBox.setSelectedItem(e);
    }

    private void makeSelection(boolean bl, int ... nArray) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            for (int n : nArray) {
                boolean bl2 = (Boolean)this.model.getValueAt(i, n);
                if (bl == bl2) continue;
                this.model.setValueAt(bl, i, n);
            }
        }
    }

    private List<CsmField> initFields(CsmObject csmObject) {
        CsmObject csmObject2 = CsmRefactoringUtils.getReferencedElement(csmObject);
        assert (csmObject2 != null) : "why unresolved element was used?";
        if (CsmKindUtilities.isClass((CsmObject)csmObject2)) {
            this.csmClassContainer = (CsmClass)csmObject2;
        } else {
            assert (CsmKindUtilities.isField((CsmObject)csmObject2)) : "should be field";
            this.csmClassContainer = ((CsmField)csmObject2).getContainingClass();
        }
        ArrayList<CsmField> arrayList = new ArrayList<CsmField>();
        Boolean bl = null;
        for (CsmMember csmMember : this.csmClassContainer.getMembers()) {
            if (CsmKindUtilities.isField((CsmObject)csmMember)) {
                arrayList.add((CsmField)csmMember);
                continue;
            }
            if (bl != null || !CsmKindUtilities.isMethod((CsmObject)csmMember)) continue;
            bl = GeneratorUtils.checkStartWithUpperCase((CsmMethod)csmMember);
        }
        this.isUpperCase = bl != null ? bl : true;
        this.classname = ((Object)this.csmClassContainer.getQualifiedName()).toString();
        String string = " - " + this.classname;
        this.setName(this.getName() + (String)string);
        return arrayList;
    }

    private void initInsertPoints() {
        CsmClass csmClass = this.csmClassContainer;
        ArrayList<InsertPoint> arrayList = new ArrayList<InsertPoint>();
        int n = 0;
        this.hasOutOfClassMemberDefinitions = false;
        for (Object object : csmClass.getMembers()) {
            if (CsmKindUtilities.isMethod((CsmObject)object)) {
                CsmMethod csmMethod = (CsmMethod)object;
                CsmFunctionDefinition object2 = csmMethod.getDefinition();
                InsertPoint insertPoint = new InsertPoint(csmClass, (CsmOffsetable)csmMethod, (CsmOffsetable)object2, n + 1, NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldInsertPointMethod", (Object)MemberInfo.create(csmMethod).getHtmlText()));
                if (object2 != null && object2 != csmMethod) {
                    this.hasOutOfClassMemberDefinitions = true;
                }
                arrayList.add(insertPoint);
            }
            ++n;
        }
        this.jComboInsertPoint.addItem(InsertPoint.DEFAULT);
        if (!arrayList.isEmpty()) {
            Object object;
            InsertPoint insertPoint = new InsertPoint(csmClass, null, null, Integer.MIN_VALUE, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.first"));
            object = new InsertPoint(csmClass, null, null, Integer.MAX_VALUE, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.last"));
            this.jComboInsertPoint.addItem(insertPoint);
            this.jComboInsertPoint.addItem(object);
            for (InsertPoint insertPoint2 : arrayList) {
                this.jComboInsertPoint.addItem(insertPoint2);
            }
        }
        this.jComboInsertPoint.setSelectedItem(InsertPoint.DEFAULT);
        if (this.hasOutOfClassMemberDefinitions) {
            this.jInlineMethods.setSelected(NbPreferences.forModule(DeclarationGenerator.class).getBoolean("inline_method", false));
            this.jInlineMethods.setEnabled(true);
        } else {
            this.jInlineMethods.setSelected(true);
            this.jInlineMethods.setEnabled(false);
        }
    }

    public final Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> getAllFields() {
        ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> arrayList = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
        Vector<Vector> vector = this.model.getDataVector();
        for (List list : vector) {
            String string;
            String string2 = (Boolean)list.get(1) != false ? ((AccessorInfo)list.get((int)2)).name : null;
            String string3 = string = (Boolean)list.get(3) != false ? ((AccessorInfo)list.get((int)4)).name : null;
            if (string2 == null && string == null) continue;
            MemberInfo memberInfo = (MemberInfo)list.get(0);
            CsmMethod csmMethod = null;
            if (((AccessorInfo)list.get((int)2)).defaultAccessor != null) {
                csmMethod = (CsmMethod)((AccessorInfo)list.get((int)2)).defaultAccessor.getElementHandle();
            }
            CsmMethod csmMethod2 = null;
            if (((AccessorInfo)list.get((int)4)).defaultAccessor != null) {
                csmMethod2 = (CsmMethod)((AccessorInfo)list.get((int)4)).defaultAccessor.getElementHandle();
            }
            arrayList.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo((CsmField)memberInfo.getElementHandle(), "".equals(string2) ? null : string2, "".equals(string) ? null : string, csmMethod, csmMethod2));
        }
        return arrayList;
    }

    public boolean isMethodInline() {
        boolean bl = this.jInlineMethods.isSelected();
        if (this.hasOutOfClassMemberDefinitions) {
            NbPreferences.forModule(DeclarationGenerator.class).putBoolean("inline_method", bl);
        }
        return bl;
    }

    public boolean isCheckAccess() {
        ALWAYS_USE_ACCESSORS = this.jCheckAccess.isSelected();
        return ALWAYS_USE_ACCESSORS;
    }

    public Set<CsmVisibility> getFieldModifiers() {
        FIELD_ACCESS_INDEX = this.jComboField.getSelectedIndex();
        CsmVisibility csmVisibility = this.getModifier(FIELD_ACCESS_INDEX);
        if (csmVisibility == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(csmVisibility);
    }

    public Set<CsmVisibility> getMethodModifiers() {
        METHOD_ACCESS_INDEX = this.jComboAccess.getSelectedIndex();
        CsmVisibility csmVisibility = this.getModifier(METHOD_ACCESS_INDEX);
        if (csmVisibility == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(csmVisibility);
    }

    private CsmVisibility getModifier(int n) {
        switch (n) {
            case 3: {
                return CsmVisibility.PRIVATE;
            }
            case 2: {
                return CsmVisibility.NONE;
            }
            case 1: {
                return CsmVisibility.PROTECTED;
            }
            case 0: {
                return CsmVisibility.PUBLIC;
            }
        }
        throw new IllegalStateException("unexpected index:" + n);
    }

    public InsertPoint getInsertPoint() {
        return (InsertPoint)this.jComboInsertPoint.getSelectedItem();
    }

    public SortBy getSortBy() {
        return (SortBy)this.jComboSort.getSelectedItem();
    }

    public Documentation getDocumentation() {
        return (Documentation)this.jComboJavadoc.getSelectedItem();
    }

    String getClassname() {
        return this.classname;
    }

    private static boolean isConstant(Object object) {
        if (CsmKindUtilities.isCsmObject((Object)object) && CsmKindUtilities.isVariable((CsmObject)((CsmObject)object))) {
            return GeneratorUtils.isConstant((CsmVariable)object);
        }
        return false;
    }

    private static final class AccessorInfoTableEditor
    extends DefaultCellEditor {
        private AccessorInfo ai;

        public AccessorInfoTableEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.ai = (AccessorInfo)object;
            if (this.ai == null) {
                throw new IllegalStateException();
            }
            String string = this.ai.name;
            return super.getTableCellEditorComponent(jTable, string, bl, n, n2);
        }

        public Object getCellEditorValue() {
            AccessorInfo accessorInfo;
            String string = (String)super.getCellEditorValue();
            if (string == null || string.length() == 0) {
                if (this.ai != null) {
                    this.ai.name = null;
                    this.ai.accessor = null;
                    this.ai.accessorToolTip = null;
                }
                accessorInfo = this.ai;
            } else {
                if (!string.equals(this.ai.name)) {
                    this.computeNewValue();
                }
                accessorInfo = this.ai;
            }
            return accessorInfo;
        }

        private void computeNewValue() {
            AccessorInfo accessorInfo = this.ai;
            assert (accessorInfo != null);
            accessorInfo.setName(((String)super.getCellEditorValue()).trim());
        }
    }

    private static final class AccessorInfoRenderer
    extends UIUtilities.CsmElementTableCellRenderer {
        private AccessorInfoRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            AccessorInfo accessorInfo = (AccessorInfo)object;
            String string = accessorInfo == null ? null : (accessorInfo.accessor == null ? accessorInfo.name : accessorInfo.accessor);
            Component component = super.getTableCellRendererComponent(jTable, string, bl, bl2, n, n2);
            String string2 = accessorInfo != null && jTable.isCellEditable(n, n2) ? accessorInfo.accessorToolTip : null;
            boolean bl3 = (Boolean)jTable.getModel().getValueAt(n, n2 - 1);
            this.setEnabled(bl3);
            if (bl3 && accessorInfo != null && !accessorInfo.isGetter && EncapsulateFieldPanel.isConstant(jTable.getValueAt(n, 0)) && (object2 = UIManager.getDefaults().get("nb.errorForeground")) instanceof Color) {
                this.setBorder(BorderFactory.createLineBorder((Color)object2));
                String string3 = NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldFinalFieldWarning");
                string2 = string2 == null ? string3 : String.format("<html>%s<br>%s</html>", string3, string2);
            }
            this.setToolTipText(string2);
            return component;
        }
    }

    private static final class EncapsulateCsmFieldTableCellRenderer
    extends UIUtilities.CsmElementTableCellRenderer {
        private EncapsulateCsmFieldTableCellRenderer() {
        }

        protected String extractText(Object object) {
            String string = super.extractText(object);
            if (string != null && EncapsulateFieldPanel.isConstant(object)) {
                string = string + " : const";
            }
            return string;
        }
    }

    public static final class InsertPoint {
        public static final InsertPoint DEFAULT = new InsertPoint(null, null, null, Integer.MIN_VALUE, EncapsulateFieldPanel.access$1000("EncapsulateFieldPanel.jComboInsertPoint.default"));
        private final int index;
        private final String description;
        private final CsmOffsetable elemDecl;
        private final CsmOffsetable elemDef;
        private final CsmClass clazz;

        private InsertPoint(CsmClass csmClass, CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2, int n, String string) {
            this.index = n;
            this.description = string;
            this.elemDecl = csmOffsetable;
            this.elemDef = csmOffsetable2;
            this.clazz = csmClass;
        }

        public CsmClass getContainerClass() {
            return this.clazz;
        }

        public CsmOffsetable getElementDeclaration() {
            return this.elemDecl;
        }

        public CsmOffsetable getElementDefinition() {
            return this.elemDef;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.description;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Documentation implements Comparator<Documentation>
    {
        DEFAULT("EncapsulateFieldPanel.jComboJavadoc.createDefault"),
        NONE("EncapsulateFieldPanel.jComboJavadoc.none"),
        COPY("EncapsulateFieldPanel.jComboJavadoc.copy");

        private final String displayName;

        private Documentation(String string2) {
            this.displayName = EncapsulateFieldPanel.getString(string2);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(Documentation documentation, Documentation documentation2) {
            if (documentation == documentation2) {
                return 0;
            }
            if (documentation == null) {
                return -1;
            }
            if (documentation2 == null) {
                return 1;
            }
            return documentation.toString().compareTo(documentation2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortBy implements Comparator<SortBy>
    {
        DEFAULT("EncapsulateFieldPanel.jComboSort.default"),
        PAIRS("EncapsulateFieldPanel.jComboSort.pairs"),
        ALPHABETICALLY("EncapsulateFieldPanel.jComboSort.alphabetically"),
        GETTERS_FIRST("EncapsulateFieldPanel.jComboSort.gettersFirst");

        private final String displayName;

        private SortBy(String string2) {
            this.displayName = EncapsulateFieldPanel.getString(string2);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(SortBy sortBy, SortBy sortBy2) {
            if (sortBy == sortBy2) {
                return 0;
            }
            if (sortBy == null) {
                return -1;
            }
            if (sortBy2 == null) {
                return 1;
            }
            return sortBy.toString().compareTo(sortBy2.toString());
        }
    }

    private static final class AccessorInfo {
        String defaultName;
        MemberInfo<? extends CsmMember> defaultAccessor;
        String name;
        String accessorToolTip;
        String defaultAccessorToolTip;
        MemberInfo<? extends CsmMember> accessor;
        private CsmField fieldHandle;
        private boolean isGetter;

        private AccessorInfo() {
        }

        public static AccessorInfo createGetter(CsmField csmField, String string) {
            CsmMethod csmMethod = EncapsulateFieldRefactoringPlugin.findMethod(csmField.getContainingClass(), string, Collections.emptyList(), true);
            return AccessorInfo.create(csmField, csmMethod, string, true);
        }

        public static AccessorInfo createSetter(CsmField csmField, String string) {
            CsmMethod csmMethod = EncapsulateFieldRefactoringPlugin.findMethod(csmField.getContainingClass(), string, Collections.singletonList(csmField), true);
            return AccessorInfo.create(csmField, csmMethod, string, false);
        }

        private static AccessorInfo create(CsmField csmField, CsmMethod csmMethod, String string, boolean bl) {
            AccessorInfo accessorInfo = new AccessorInfo();
            accessorInfo.name = accessorInfo.defaultName = string;
            accessorInfo.defaultAccessor = csmMethod != null ? MemberInfo.create(csmMethod) : null;
            accessorInfo.accessor = accessorInfo.defaultAccessor;
            accessorInfo.defaultAccessorToolTip = csmMethod != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(bl ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)((Object)csmMethod.getName()).toString()) : null;
            accessorInfo.accessorToolTip = accessorInfo.defaultAccessorToolTip;
            accessorInfo.isGetter = bl;
            accessorInfo.fieldHandle = csmField;
            return accessorInfo;
        }

        public void reset() {
            this.name = this.defaultName;
            this.accessor = this.defaultAccessor;
            this.accessorToolTip = this.defaultAccessorToolTip;
        }

        public void setName(String string) {
            this.name = string;
            CsmField csmField = this.fieldHandle;
            CsmMethod csmMethod = null;
            csmMethod = this.isGetter ? EncapsulateFieldRefactoringPlugin.findMethod(csmField.getContainingClass(), string, Collections.emptyList(), true) : EncapsulateFieldRefactoringPlugin.findMethod(csmField.getContainingClass(), string, Collections.singletonList(csmField), true);
            MemberInfo<CsmMethod> memberInfo = this.accessor = csmMethod != null ? MemberInfo.create(csmMethod) : null;
            this.accessorToolTip = csmMethod != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(this.isGetter ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)((Object)csmMethod.getName()).toString()) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] objectArray, int n) {
            super(objectArray, n);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return columnTypes[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1 || n2 == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(n, n2 - 1);
        }
    }
}

