/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.refactoring.introduce.ErrorLabel;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceFieldPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceMethodPanel
extends JPanel {
    public static final int INIT_METHOD = 1;
    public static final int INIT_FIELD = 2;
    public static final int INIT_CONSTRUCTORS = 4;
    private static final int ACCESS_PUBLIC = 1;
    private static final int ACCESS_PROTECTED = 2;
    private static final int ACCESS_PRIVATE = 4;
    private JButton btnOk;
    private ButtonGroup accessGroup;
    private JRadioButton accessPrivate;
    private JRadioButton accessProtected;
    private JRadioButton accessPublic;
    private JLabel errorLabel;
    private ButtonGroup initilizeIn;
    private JLabel lblAccess;
    private JLabel lblName;
    private JTextField name;
    private String methodNameTest;
    private CsmVisibility accessTest;

    public IntroduceMethodPanel(String string) {
        this.initComponents();
        this.name.setText(string);
        if (string != null && string.trim().length() > 0) {
            this.name.setCaretPosition(string.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(string.length());
        }
        Preferences preferences = this.getPreferences();
        int n = preferences.getInt("accessModifier", 4);
        switch (n) {
            case 1: {
                this.accessPublic.setSelected(true);
                break;
            }
            case 2: {
                this.accessProtected.setSelected(true);
                break;
            }
            case 4: {
                this.accessPrivate.setSelected(true);
            }
        }
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(IntroduceFieldPanel.class).node("introduceField");
    }

    public void setOkButton(JButton jButton) {
        this.btnOk = jButton;
        this.btnOk.setEnabled(((ErrorLabel)this.errorLabel).isInputTextValid());
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            public String validate(String string) {
                if (null == string || string.length() == 0) {
                    return "";
                }
                if (!CndLexerUtilities.isCppIdentifier((CharSequence)string)) {
                    return IntroduceMethodPanel.this.getDefaultErrorMessage(string);
                }
                return null;
            }
        };
        final ErrorLabel errorLabel = new ErrorLabel(this.name.getDocument(), validator);
        errorLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                IntroduceMethodPanel.this.btnOk.setEnabled(errorLabel.isInputTextValid());
            }
        });
        return errorLabel;
    }

    String getDefaultErrorMessage(String string) {
        return "'" + string + "' is not a valid identifier";
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.lblAccess = new JLabel();
        this.accessPublic = new JRadioButton();
        this.accessProtected = new JRadioButton();
        this.accessPrivate = new JRadioButton();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        this.lblAccess.setLabelFor(this.accessPublic);
        Mnemonics.setLocalizedText((JLabel)this.lblAccess, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_Access"));
        this.accessGroup.add(this.accessPublic);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPublic, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_public"));
        this.accessPublic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPublic.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessProtected);
        Mnemonics.setLocalizedText((AbstractButton)this.accessProtected, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_protected"));
        this.accessProtected.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessProtected.setMargin(new Insets(0, 0, 0, 0));
        this.accessGroup.add(this.accessPrivate);
        this.accessPrivate.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.accessPrivate, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_private"));
        this.accessPrivate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.accessPrivate.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblAccess).add((Component)this.lblName)).add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.name, -1, 425, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.accessPublic).addPreferredGap(0).add((Component)this.accessProtected).addPreferredGap(0).add((Component)this.accessPrivate)))).add((Component)this.errorLabel, -1, 495, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.name, -2, -1, -2).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblAccess).add((Component)this.accessPublic).add((Component)this.accessProtected).add((Component)this.accessPrivate)).addPreferredGap(0, 137, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AN_IntrMethod_Name"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Name"));
        this.accessPublic.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Public"));
        this.accessProtected.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Protected"));
        this.accessPrivate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Private"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Dialog"));
    }

    public String getMethodName() {
        if (this.methodNameTest != null) {
            return this.methodNameTest;
        }
        return this.name.getText();
    }

    public CsmVisibility getAccess() {
        CsmVisibility csmVisibility;
        int n;
        if (this.accessTest != null) {
            return this.accessTest;
        }
        if (this.accessPublic.isSelected()) {
            n = 1;
            csmVisibility = CsmVisibility.PUBLIC;
        } else if (this.accessProtected.isSelected()) {
            n = 2;
            csmVisibility = CsmVisibility.PROTECTED;
        } else {
            n = 4;
            csmVisibility = CsmVisibility.PRIVATE;
        }
        this.getPreferences().putInt("accessModifier", n);
        return csmVisibility;
    }

    void setAccess(CsmVisibility csmVisibility) {
        this.accessTest = csmVisibility;
    }

    void setMethodName(String string) {
        this.methodNameTest = string;
    }
}

