/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.SourceUtilsEx;
import org.netbeans.modules.refactoring.java.WhereUsedElement;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.FindOverridingVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindSubtypesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindUsagesVisitor;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaWhereUsedQueryPlugin
extends JavaRefactoringPlugin {
    private WhereUsedQuery refactoring;

    public JavaWhereUsedQueryPlugin(WhereUsedQuery whereUsedQuery) {
        this.refactoring = whereUsedQuery;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        switch (phase) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getFileObject());
    }

    @Override
    public Problem preCheck() {
        TreePathHandle treePathHandle = (TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (!treePathHandle.getFileObject().isValid() || RetoucheUtils.getElementKind(treePathHandle) == null) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
        }
        if (treePathHandle.getKind() == Tree.Kind.ARRAY_TYPE) {
            return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"ERR_FindUsagesArrayType"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle treePathHandle) {
        return JavaWhereUsedQueryPlugin.getRelevantFiles(treePathHandle, this.getClasspathInfo((AbstractRefactoring)this.refactoring), this.isFindSubclasses(), this.isFindDirectSubclassesOnly(), this.isFindOverridingMethods(), this.isFindUsages());
    }

    public static Set<FileObject> getRelevantFiles(final TreePathHandle treePathHandle, final ClasspathInfo classpathInfo, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        JavaSource javaSource;
        final ClassIndex classIndex = classpathInfo.getClassIndex();
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        FileObject fileObject = treePathHandle.getFileObject();
        if (fileObject != null) {
            hashSet.add(fileObject);
            javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{treePathHandle.getFileObject()});
        } else {
            javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        }
        CancellableTask<CompilationController> cancellableTask = new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController compilationController) throws Exception {
                Set<ElementHandle<TypeElement>> set;
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                if (element == null) {
                    throw new NullPointerException(String.format("#145291: Cannot resolve handle: %s\n%s", treePathHandle, compilationController.getClasspathInfo()));
                }
                if (element.getKind().isField()) {
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                } else if (element.getKind().isClass() || element.getKind().isInterface()) {
                    if (bl || bl2) {
                        if (bl2) {
                            set = EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS);
                            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element)), (Set)set, EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        } else {
                            hashSet.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(classIndex, classpathInfo, (TypeElement)element));
                        }
                    } else {
                        hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element)), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                } else if (element.getKind() == ElementKind.METHOD && bl3) {
                    set = (TypeElement)element.getEnclosingElement();
                    hashSet.addAll(JavaWhereUsedQueryPlugin.getImplementorsRecursive(classIndex, classpathInfo, (TypeElement)((Object)set)));
                }
                if (element.getKind() == ElementKind.METHOD && bl4) {
                    set = RetoucheUtils.getImplementorsAsHandles(classIndex, classpathInfo, (TypeElement)element.getEnclosingElement());
                    for (ElementHandle<TypeElement> elementHandle : set) {
                        TypeElement typeElement = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                        if (typeElement == null) continue;
                        for (Element element2 : typeElement.getEnclosedElements()) {
                            if (!(element2 instanceof ExecutableElement) || !compilationController.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, typeElement)) continue;
                            hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        }
                    }
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                } else if (element.getKind() == ElementKind.CONSTRUCTOR) {
                    hashSet.addAll(classIndex.getResources(ElementHandle.create((Element)((TypeElement)element.getEnclosingElement())), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                }
            }
        };
        try {
            javaSource.runUserActionTask((Task)cancellableTask, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return hashSet;
    }

    private static Collection<FileObject> getImplementorsRecursive(ClassIndex classIndex, ClasspathInfo classpathInfo, TypeElement typeElement) {
        Set<ElementHandle<? extends Element>> set = RetoucheUtils.getImplementorsAsHandles(classIndex, classpathInfo, typeElement);
        Collection<FileObject> collection = SourceUtilsEx.getFiles(set, classpathInfo);
        ClassPath classPath = classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(collection.size());
        for (FileObject fileObject : collection) {
            if (!classPath.contains(fileObject)) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        this.fireProgressListenerStart(1, -1);
        Set<FileObject> set = this.getRelevantFiles((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class));
        this.fireProgressListenerStep(set.size());
        Problem problem = null;
        try {
            this.processFiles(set, new FindTask(refactoringElementsBag));
        }
        catch (IOException iOException) {
            problem = this.createProblemAndLog(null, iOException);
        }
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    public Problem fastCheckParameters() {
        if (((TreePathHandle)this.refactoring.getRefactoringSource().lookup(TreePathHandle.class)).getKind() == Tree.Kind.METHOD) {
            return this.checkParametersForMethod(this.isFindOverridingMethods(), this.isFindUsages());
        }
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    private Problem checkParametersForMethod(boolean bl, boolean bl2) {
        if (!bl2 && !bl) {
            return new Problem(true, NbBundle.getMessage(JavaWhereUsedQueryPlugin.class, (String)"MSG_NothingToFind"));
        }
        return null;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchFromBaseClass() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindTask
    implements CancellableTask<WorkingCopy> {
        private RefactoringElementsBag elements;
        private volatile boolean cancelled;

        public FindTask(RefactoringElementsBag refactoringElementsBag) {
            this.elements = refactoringElementsBag;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run(WorkingCopy workingCopy) throws IOException {
            Object object;
            if (this.cancelled) {
                return;
            }
            if (workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                return;
            }
            CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
            if (compilationUnitTree == null) {
                ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                return;
            }
            TreePathHandle treePathHandle = (TreePathHandle)JavaWhereUsedQueryPlugin.this.refactoring.getRefactoringSource().lookup(TreePathHandle.class);
            Element element = treePathHandle.resolveElement((CompilationInfo)workingCopy);
            if (element == null) {
                ErrorManager.getDefault().log(65536, "element is null for handle " + treePathHandle);
                return;
            }
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            if (JavaWhereUsedQueryPlugin.this.isFindUsages()) {
                WhereUsedQuery whereUsedQuery = JavaWhereUsedQueryPlugin.this.refactoring;
                JavaWhereUsedQueryPlugin.this.refactoring;
                object = new FindUsagesVisitor(workingCopy, whereUsedQuery.getBooleanValue((Object)"SEARCH_IN_COMMENTS"));
                ((TreePathScanner)object).scan(workingCopy.getCompilationUnit(), element);
                arrayList.addAll(((FindVisitor)object).getUsages());
                for (FindUsagesVisitor.UsageInComment usageInComment : ((FindUsagesVisitor)object).getUsagesInComments()) {
                    this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(usageInComment.from, usageInComment.to, (CompilationInfo)workingCopy));
                }
            }
            if (element.getKind() == ElementKind.METHOD && JavaWhereUsedQueryPlugin.this.isFindOverridingMethods()) {
                object = new FindOverridingVisitor(workingCopy);
                ((TreePathScanner)object).scan(workingCopy.getCompilationUnit(), element);
                arrayList.addAll(((FindVisitor)object).getUsages());
            } else if ((element.getKind().isClass() || element.getKind().isInterface()) && (JavaWhereUsedQueryPlugin.this.isFindSubclasses() || JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly())) {
                object = new FindSubtypesVisitor(!JavaWhereUsedQueryPlugin.this.isFindDirectSubclassesOnly(), workingCopy);
                ((TreePathScanner)object).scan(workingCopy.getCompilationUnit(), element);
                arrayList.addAll(((FindVisitor)object).getUsages());
            }
            for (TreePath treePath : arrayList) {
                this.elements.add((AbstractRefactoring)JavaWhereUsedQueryPlugin.this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create((CompilationInfo)workingCopy, treePath));
            }
            JavaWhereUsedQueryPlugin.this.fireProgressListenerStep();
        }
    }
}

