/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.InnerToOuterRefactoring;
import org.netbeans.modules.refactoring.java.plugins.InnerToOuterTransformer;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerToOuterRefactoringPlugin
extends JavaRefactoringPlugin {
    private final InnerToOuterRefactoring refactoring;
    private TreePathHandle treePathHandle;

    InnerToOuterRefactoringPlugin(InnerToOuterRefactoring innerToOuterRefactoring) {
        this.refactoring = innerToOuterRefactoring;
        this.treePathHandle = (TreePathHandle)innerToOuterRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        switch (phase) {
            case PRECHECK: {
                ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
                return JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
            }
        }
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 4);
        Problem problem = null;
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
        TreePathHandle treePathHandle = this.refactoring.getSourceType();
        Problem problem2 = InnerToOuterRefactoringPlugin.isElementAvail(treePathHandle, (CompilationInfo)compilationController);
        if (problem2 != null) {
            return problem2;
        }
        problem2 = JavaPluginUtils.isSourceElement(element, (CompilationInfo)compilationController);
        if (problem2 != null) {
            return problem2;
        }
        this.refactoring.setClassName(RetoucheUtils.getSimpleName(treePathHandle));
        this.fireProgressListenerStep();
        if (element instanceof TypeElement) {
            if (((TypeElement)element).getNestingKind() == NestingKind.ANONYMOUS) {
                problem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_Anonymous"));
                return problem;
            }
            if (!((TypeElement)element).getNestingKind().isNested()) {
                problem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
                return problem;
            }
        } else {
            problem = new Problem(true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InnerToOuter_MustBeInnerClass"));
            return problem;
        }
        this.fireProgressListenerStep();
        this.refactoring.setReferenceName("outer");
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        FileObject[] fileObjectArray;
        Problem problem = null;
        String string = this.refactoring.getClassName();
        if (!Utilities.isJavaIdentifier((String)string)) {
            problem = InnerToOuterRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_InvalidIdentifier", (Object)string));
            return problem;
        }
        FileObject fileObject = this.refactoring.getSourceType().getFileObject();
        FileObject fileObject2 = fileObject.getParent();
        for (FileObject fileObject3 : fileObjectArray = fileObject2.getChildren()) {
            if (fileObject3.isVirtual() || !fileObject3.getName().equals(string) || !"java".equals(fileObject3.getExt())) continue;
            problem = InnerToOuterRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(InnerToOuterRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)string, (Object)fileObject2.getName()));
            return problem;
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        ClassIndex classIndex = classpathInfo.getClassIndex();
        hashSet.addAll(classIndex.getResources(RetoucheUtils.getElementHandle(this.refactoring.getSourceType()), EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        return hashSet;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        InnerToOuterTransformer innerToOuterTransformer = new InnerToOuterTransformer(this.refactoring);
        JavaRefactoringPlugin.TransformTask transformTask = new JavaRefactoringPlugin.TransformTask(this, innerToOuterTransformer, this.refactoring.getSourceType());
        Problem problem = this.createAndAddElements(set, transformTask, refactoringElementsBag, this.refactoring);
        this.fireProgressListenerStop();
        return problem != null ? problem : innerToOuterTransformer.getProblem();
    }
}

