/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.InnerClassesNode;
import org.netbeans.modules.profiler.selector.spi.nodes.MethodsNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;

public abstract class ClassNode
extends ContainerNode {
    private boolean anonymous;
    public static final Comparator COMPARATOR = new Comparator<ClassNode>(){

        @Override
        public int compare(ClassNode classNode, ClassNode classNode2) {
            return classNode.toString().compareTo(classNode2.toString());
        }
    };

    public ClassNode(String string, String string2, Icon icon, boolean bl, ContainerNode containerNode) {
        super(string, string2, icon, containerNode);
        this.anonymous = bl;
    }

    public ClassNode(String string, String string2, boolean bl, ContainerNode containerNode) {
        super(string, string2, (Icon)IconResource.CLASS_ICON, containerNode);
        this.anonymous = bl;
    }

    protected final SelectorChildren getChildren() {
        return new ClassChildren();
    }

    public final boolean isAnonymous() {
        return this.anonymous;
    }

    protected abstract ConstructorsNode getConstructorsNode();

    protected abstract MethodsNode getMethodsNode();

    protected abstract InnerClassesNode getInnerClassesNode();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassChildren
    extends SelectorChildren<ClassNode> {
        private ClassChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(ClassNode classNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            ContainerNode containerNode = null;
            if (!classNode.isAnonymous() && (containerNode = classNode.getConstructorsNode()) != null && !containerNode.isLeaf()) {
                arrayList.add(containerNode);
            }
            if ((containerNode = classNode.getMethodsNode()) != null && !containerNode.isLeaf()) {
                arrayList.add(containerNode);
            }
            if ((containerNode = classNode.getInnerClassesNode()) != null && !containerNode.isLeaf()) {
                arrayList.add(containerNode);
            }
            return arrayList;
        }
    }
}

