/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsfret.source.parsing.SourceFileObject;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationInfo
extends org.netbeans.modules.gsf.api.CompilationInfo {
    private Phase phase = Phase.MODIFIED;
    private ParserTaskImpl javacTask;
    final SourceFileObject jfo;
    final Source javaSource;
    boolean needsRestart;
    private Language language;
    private Map<String, ParserResult> embeddedResults = new HashMap<String, ParserResult>();
    private Set<String> unchanged;
    private EditHistory history;

    CompilationInfo() throws IOException {
        super(null);
        this.javaSource = null;
        this.jfo = null;
        this.javacTask = null;
    }

    CompilationInfo(Source source, FileObject fileObject, ParserTaskImpl parserTaskImpl) throws IOException {
        super(fileObject);
        assert (source != null);
        this.javaSource = source;
        this.jfo = fileObject.isValid() && !fileObject.isVirtual() ? new SourceFileObject(fileObject, true) : null;
        this.javacTask = parserTaskImpl;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public String getText() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        try {
            return this.jfo.getCharContent(false).toString();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public TokenHierarchy<?> getTokenHierarchy() {
        if (this.jfo == null) {
            throw new IllegalStateException();
        }
        try {
            return this.jfo.getTokenHierarchy();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    public Source getSource() {
        return this.javaSource;
    }

    public ClasspathInfo getClasspathInfo() {
        return this.javaSource.getClasspathInfo();
    }

    public Index getIndex(String string) {
        return this.getClasspathInfo().getClassIndex(string);
    }

    void setPhase(Phase phase) {
        assert (phase != null);
        this.phase = phase;
    }

    synchronized ParserTaskImpl getParserTask() {
        if (this.javacTask == null) {
            this.javacTask = this.javaSource.createParserTask(this);
        }
        return this.javacTask;
    }

    public Language getLanguage() {
        if (this.language == null) {
            FileObject fileObject = this.getFileObject();
            String string = fileObject.getMIMEType();
            this.language = LanguageRegistry.getInstance().getLanguageByMimeType(string);
        }
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Set<String> getEmbeddedMimeTypes() {
        return this.embeddedResults.keySet();
    }

    public void addEmbeddingResult(String string, ParserResult parserResult) {
        this.embeddedResults.put(string, parserResult);
        parserResult.setInfo((org.netbeans.modules.gsf.api.CompilationInfo)this);
    }

    public Collection<? extends ParserResult> getEmbeddedResults(String string) {
        ParserResult parserResult = this.getEmbeddedResult(string, 0);
        if (parserResult != null) {
            return Collections.singletonList(parserResult);
        }
        return Collections.emptyList();
    }

    public ParserResult getEmbeddedResult(String string, int n) {
        ParserResult parserResult = this.embeddedResults.get(string);
        return parserResult;
    }

    public boolean hasUnchangedResults() {
        for (ParserResult parserResult : this.embeddedResults.values()) {
            if (!parserResult.getUpdateState().isUnchanged()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInvalidResults() {
        for (ParserResult parserResult : this.embeddedResults.values()) {
            if (parserResult.isValid()) continue;
            return true;
        }
        return false;
    }

    public List<Error> getErrors() {
        ArrayList<Error> arrayList = new ArrayList<Error>();
        for (ParserResult parserResult : this.embeddedResults.values()) {
            arrayList.addAll(parserResult.getDiagnostics());
        }
        return arrayList;
    }

    public String toString() {
        return "CompilationInfo for " + FileUtil.getFileDisplayName((FileObject)this.getFileObject()) + "; phase=" + (Object)((Object)this.getPhase());
    }

    public EditHistory getHistory() {
        return this.history;
    }

    public void setHistory(EditHistory editHistory) {
        this.history = editHistory;
    }
}

